/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.DeclinedTransactionException;
import com.onlinepayments.domain.CreatePaymentResponse;
import com.onlinepayments.domain.PaymentErrorResponse;
import com.onlinepayments.domain.PaymentResponse;

public class DeclinedPaymentException
extends DeclinedTransactionException {
    private final PaymentErrorResponse errorResponse;

    public DeclinedPaymentException(int statusCode, String responseBody, PaymentErrorResponse errorResponse) {
        super(DeclinedPaymentException.buildMessage(errorResponse), statusCode, responseBody, errorResponse != null ? errorResponse.getErrorId() : null, errorResponse != null ? errorResponse.getErrors() : null);
        this.errorResponse = errorResponse;
    }

    private static String buildMessage(PaymentErrorResponse errors) {
        PaymentResponse payment;
        PaymentResponse paymentResponse = payment = errors != null && errors.getPaymentResult() != null ? errors.getPaymentResult().getPayment() : null;
        if (payment != null) {
            return "declined payment '" + payment.getId() + "' with status '" + payment.getStatus() + "'";
        }
        return "the Online Payments platform returned a declined payment response";
    }

    public CreatePaymentResponse getCreatePaymentResult() {
        return this.errorResponse == null ? null : this.errorResponse.getPaymentResult();
    }
}

