/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.DeclinedTransactionException;
import com.onlinepayments.domain.PayoutErrorResponse;
import com.onlinepayments.domain.PayoutResult;

public class DeclinedPayoutException
extends DeclinedTransactionException {
    private final PayoutErrorResponse errors;

    public DeclinedPayoutException(int statusCode, String responseBody, PayoutErrorResponse errors) {
        super(DeclinedPayoutException.buildMessage(errors), statusCode, responseBody, errors != null ? errors.getErrorId() : null, errors != null ? errors.getErrors() : null);
        this.errors = errors;
    }

    private static String buildMessage(PayoutErrorResponse errors) {
        PayoutResult payout;
        PayoutResult payoutResult = payout = errors != null ? errors.getPayoutResult() : null;
        if (payout != null) {
            return "declined payout '" + payout.getId() + "' with status '" + payout.getStatus() + "'";
        }
        return "the Online Payments platform returned a declined payout response";
    }

    public PayoutResult getPayoutResult() {
        return this.errors == null ? null : this.errors.getPayoutResult();
    }
}

