/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.DeclinedTransactionException;
import com.onlinepayments.domain.RefundErrorResponse;
import com.onlinepayments.domain.RefundResponse;

public class DeclinedRefundException
extends DeclinedTransactionException {
    private final RefundErrorResponse errorResponse;

    public DeclinedRefundException(int statusCode, String responseBody, RefundErrorResponse errorResponse) {
        super(DeclinedRefundException.buildMessage(errorResponse), statusCode, responseBody, errorResponse != null ? errorResponse.getErrorId() : null, errorResponse != null ? errorResponse.getErrors() : null);
        this.errorResponse = errorResponse;
    }

    private static String buildMessage(RefundErrorResponse errors) {
        RefundResponse refund;
        RefundResponse refundResponse = refund = errors != null ? errors.getRefundResult() : null;
        if (refund != null) {
            return "declined refund '" + refund.getId() + "' with status '" + refund.getStatus() + "'";
        }
        return "the Online Payments platform returned a declined refund response";
    }

    public RefundResponse getRefundResult() {
        return this.errorResponse == null ? null : this.errorResponse.getRefundResult();
    }
}

