/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.Authenticator;
import com.onlinepayments.Client;
import com.onlinepayments.ClientInterface;
import com.onlinepayments.Communicator;
import com.onlinepayments.CommunicatorBuilder;
import com.onlinepayments.CommunicatorConfiguration;
import com.onlinepayments.Connection;
import com.onlinepayments.MetaDataProvider;
import com.onlinepayments.MetaDataProviderBuilder;
import com.onlinepayments.defaultimpl.DefaultAuthenticator;
import com.onlinepayments.defaultimpl.DefaultCommunicator;
import com.onlinepayments.defaultimpl.DefaultConnection;
import com.onlinepayments.defaultimpl.DefaultMarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;

public final class Factory {
    private Factory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommunicatorConfiguration createConfiguration(URI configurationFileUri, String apiKeyId, String secretApiKey) {
        try {
            Properties properties = new Properties();
            InputStream configurationFileInputStream = configurationFileUri.toURL().openStream();
            try {
                properties.load(configurationFileInputStream);
            }
            finally {
                configurationFileInputStream.close();
            }
            return new CommunicatorConfiguration(properties).withApiKeyId(apiKeyId).withSecretApiKey(secretApiKey);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load properties", e);
        }
    }

    public static CommunicatorBuilder createCommunicatorBuilder(URI configurationFileUri, String apiKeyId, String secretApiKey) {
        CommunicatorConfiguration configuration = Factory.createConfiguration(configurationFileUri, apiKeyId, secretApiKey);
        return Factory.createCommunicatorBuilder(configuration);
    }

    public static CommunicatorBuilder createCommunicatorBuilder(CommunicatorConfiguration configuration) {
        MetaDataProvider metaDataProvider = new MetaDataProviderBuilder(configuration.getIntegrator()).withShoppingCartExtension(configuration.getShoppingCartExtension()).build();
        return new CommunicatorBuilder().withAPIEndpoint(configuration.getApiEndpoint()).withConnection(new DefaultConnection(configuration.getConnectionRequestTimeout(), configuration.getConnectTimeout(), configuration.getSocketTimeout(), configuration.getMaxConnections(), configuration.getProxyConfiguration(), configuration.getHttpsProtocols())).withMetaDataProvider(metaDataProvider).withAuthenticator(new DefaultAuthenticator(configuration.getApiKeyId(), configuration.getSecretApiKey(), configuration.getAuthorizationType())).withMarshaller(DefaultMarshaller.INSTANCE);
    }

    public static Communicator createCommunicator(URI configurationFileUri, String apiKeyId, String secretApiKey) {
        CommunicatorConfiguration configuration = Factory.createConfiguration(configurationFileUri, apiKeyId, secretApiKey);
        return Factory.createCommunicator(configuration);
    }

    public static Communicator createCommunicator(CommunicatorConfiguration configuration) {
        return Factory.createCommunicatorBuilder(configuration).build();
    }

    public static Communicator createCommunicator(URI apiEndpoint, Connection connection, Authenticator authenticator, MetaDataProvider metaDataProvider) {
        return new DefaultCommunicator(apiEndpoint, connection, authenticator, metaDataProvider, DefaultMarshaller.INSTANCE);
    }

    public static ClientInterface createClient(URI configurationFileUri, String apiKeyId, String secretApiKey) {
        return Factory.createClient(Factory.createCommunicator(configurationFileUri, apiKeyId, secretApiKey));
    }

    public static ClientInterface createClient(CommunicatorConfiguration configuration) {
        return Factory.createClient(Factory.createCommunicator(configuration));
    }

    public static ClientInterface createClient(URI apiEndpoint, Connection connection, Authenticator authenticator, MetaDataProvider metaDataProvider) {
        return Factory.createClient(Factory.createCommunicator(apiEndpoint, connection, authenticator, metaDataProvider));
    }

    public static ClientInterface createClient(Communicator communicator) {
        return new Client(communicator);
    }
}

