/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.nio.file;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.nio.file.OvertherePath;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;

public class OverthereDirectoryStream
implements DirectoryStream<Path> {
    private Iterable<Path> paths;

    public OverthereDirectoryStream(OvertherePath dir, DirectoryStream.Filter<? super Path> filter) {
        this.initEntries(dir, filter);
    }

    private void initEntries(final OvertherePath dir, final DirectoryStream.Filter<? super Path> filter) {
        List overthereFiles = dir.getOverthereFile().listFiles();
        this.paths = Iterables.filter((Iterable)Lists.transform((List)overthereFiles, (Function)new Function<OverthereFile, Path>(){

            public Path apply(OverthereFile input) {
                return new OvertherePath(dir.getOverthereFileSystem(), input.getPath());
            }
        }), (Predicate)new Predicate<Path>(){

            public boolean apply(Path input) {
                try {
                    return filter.accept(input);
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
    }

    @Override
    public Iterator<Path> iterator() {
        return this.paths.iterator();
    }

    @Override
    public void close() throws IOException {
    }
}

