/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.nio.file;

import com.google.common.base.Joiner;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.nio.file.OverthereFileSystemProvider;
import com.xebialabs.overthere.nio.file.OvertherePath;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.Set;

public class OverthereFileSystem
extends FileSystem {
    private OverthereFileSystemProvider provider;
    private OverthereConnection connection;
    private URI uri;

    public OverthereFileSystem(OverthereFileSystemProvider provider, OverthereConnection connection, URI uri) {
        this.provider = provider;
        this.connection = connection;
        this.uri = uri;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        Closeables.closeQuietly((Closeable)this.connection);
        this.connection = null;
        this.provider.cache.remove(this.uri);
    }

    @Override
    public boolean isOpen() {
        return this.connection != null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return this.connection.getHostOperatingSystem().getFileSeparator();
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(this.getRoot());
    }

    protected Path getRoot() {
        return this.getPath("/", new String[0]);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path getPath(String first, String ... more) {
        String sep = this.getSeparator();
        StringBuilder path = new StringBuilder();
        path.append(first);
        if (more.length > 0) {
            path.append(sep);
            Joiner.on((String)sep).skipNulls().appendTo(path, (Object[])more);
        }
        return new OvertherePath(this, path.toString());
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException();
    }

    public OverthereConnection getConnection() {
        return this.connection;
    }

    URI getUri() {
        return this.uri;
    }
}

