/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.nio.file;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.nio.file.OverthereDirectoryStream;
import com.xebialabs.overthere.nio.file.OverthereFileAttributes;
import com.xebialabs.overthere.nio.file.OverthereFileSystem;
import com.xebialabs.overthere.nio.file.OvertherePath;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public abstract class OverthereFileSystemProvider
extends FileSystemProvider {
    Map<URI, OverthereFileSystem> cache = Maps.newHashMap();

    @Override
    public synchronized FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        if (this.cache.containsKey(uri)) {
            throw new FileSystemAlreadyExistsException(uri.toString());
        }
        ConnectionOptions options = this.buildOptionsFromUri(uri);
        this.copyEnvironment(env, options);
        OverthereConnection connection = this.getConnection(options);
        OverthereFileSystem overthereFileSystem = new OverthereFileSystem(this, connection, uri);
        this.cache.put(uri, overthereFileSystem);
        return overthereFileSystem;
    }

    private ConnectionOptions buildOptionsFromUri(URI uri) {
        ConnectionOptions options = new ConnectionOptions();
        this.copyHostAndPort(uri, options);
        this.copyUserInfo(uri, options);
        this.copyQuery(uri, options);
        return options;
    }

    protected OverthereConnection getConnection(ConnectionOptions options) {
        return Overthere.getConnection((String)this.getScheme(), (ConnectionOptions)options);
    }

    protected void copyHostAndPort(URI uri, ConnectionOptions options) {
        int port;
        String host = uri.getHost();
        if (host != null) {
            options.set("address", (Object)host);
        }
        if ((port = uri.getPort()) != -1) {
            options.set("port", (Object)port);
        }
    }

    protected void copyUserInfo(URI uri, ConnectionOptions options) {
        String[] userInfoParts;
        String userInfo = uri.getUserInfo();
        if (userInfo != null && (userInfoParts = userInfo.split(":", 2)).length >= 1) {
            options.set("username", (Object)userInfoParts[0]);
            if (userInfoParts.length >= 2) {
                options.set("password", (Object)userInfoParts[1]);
            }
        }
    }

    protected void copyQuery(URI uri, ConnectionOptions options) {
        List parsedQuery = URLEncodedUtils.parse((URI)uri, null);
        for (NameValuePair queryEntry : parsedQuery) {
            options.set(queryEntry.getName(), (Object)queryEntry.getValue());
        }
    }

    protected void copyEnvironment(Map<String, ?> env, ConnectionOptions options) {
        for (Map.Entry<String, ?> envEntry : env.entrySet()) {
            options.set(envEntry.getKey(), envEntry.getValue());
        }
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        if (!this.cache.containsKey(uri)) {
            throw new FileSystemNotFoundException(uri.toString());
        }
        return this.cache.get(uri);
    }

    @Override
    public Path getPath(URI uri) {
        try {
            URI uri1 = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), "/", uri.getQuery(), uri.getFragment());
            if (!this.cache.containsKey(uri1)) {
                this.newFileSystem(uri1, Maps.newHashMap());
            }
            return this.cache.get(uri1).getPath(uri.getPath(), new String[0]);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create URI for FileSystem lookup/creation", e);
        }
        catch (IOException e) {
            throw new FileSystemNotFoundException("Could not get or create FileSystem");
        }
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        OverthereFile ofile = ((OvertherePath)path).getOverthereFile();
        final InputStream in = options.contains(StandardOpenOption.READ) ? ofile.getInputStream() : null;
        final OutputStream out = !Sets.intersection(options, (Set)Sets.newHashSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.CREATE_NEW})).isEmpty() ? ofile.getOutputStream() : null;
        return new SeekableByteChannel(){

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() throws IOException {
                Closeables.closeQuietly((Closeable)in);
                Closeables.closeQuietly((Closeable)out);
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                int remaining = src.remaining();
                out.write(src.array(), 0, remaining);
                src.position(remaining);
                return remaining;
            }

            @Override
            public SeekableByteChannel truncate(long size) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long size() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                byte[] buf = new byte[dst.remaining()];
                int bytesRead = in.read(buf);
                dst.put(buf, 0, bytesRead);
                return bytesRead;
            }

            @Override
            public SeekableByteChannel position(long newPosition) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long position() throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new NotDirectoryException(dir.toString());
        }
        return new OverthereDirectoryStream((OvertherePath)dir, filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        if (Files.exists(dir, new LinkOption[0])) {
            throw new FileAlreadyExistsException(dir.toString());
        }
        try {
            ((OvertherePath)dir).getOverthereFile().mkdir();
        }
        catch (RuntimeIOException rio) {
            throw new IOException(rio);
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        ((OvertherePath)path).getOverthereFile().delete();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return ((OvertherePath)path).getOverthereFile().isHidden();
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        OverthereFile overthereFile = ((OvertherePath)path).getOverthereFile();
        if (!overthereFile.exists()) {
            throw new NoSuchFileException(path.toString());
        }
        if (modes == null) {
            return;
        }
        block5: for (AccessMode mode : modes) {
            switch (mode) {
                case READ: {
                    OverthereFileSystemProvider.checkAccess(overthereFile.canRead(), path, "Can not read");
                    continue block5;
                }
                case WRITE: {
                    OverthereFileSystemProvider.checkAccess(overthereFile.canWrite(), path, "Can not write");
                    continue block5;
                }
                case EXECUTE: {
                    OverthereFileSystemProvider.checkAccess(overthereFile.canExecute(), path, "Can not execute");
                }
            }
        }
    }

    private static void checkAccess(boolean access, Path path, String message) throws AccessDeniedException {
        if (!access) {
            throw new AccessDeniedException(path.toString(), null, message);
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (!BasicFileAttributes.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException("Don't support non BasicFileAttributes.");
        }
        OverthereFile overthereFile = ((OvertherePath)path).getOverthereFile();
        return (A)new OverthereFileAttributes(overthereFile);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }
}

