/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.nio.process;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.nio.file.OverthereFileSystem;
import com.xebialabs.overthere.util.ConsoleOverthereProcessOutputHandler;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;

public class Processes {
    public static int execute(Path path, String ... arguments) {
        OverthereConnection connection = Processes.getOverthereConnection(path);
        CmdLine commandLine = Processes.toCommandLine(path, arguments);
        return connection.execute((OverthereProcessOutputHandler)ConsoleOverthereProcessOutputHandler.consoleHandler(), commandLine);
    }

    public static OverthereProcess startProcess(Path path, String ... arguments) {
        OverthereConnection connection = Processes.getOverthereConnection(path);
        CmdLine commandLine = Processes.toCommandLine(path, arguments);
        if (connection.canStartProcess()) {
            return connection.startProcess(commandLine);
        }
        throw new IllegalArgumentException("The connection does not support starting (long running) processes.");
    }

    private static OverthereConnection getOverthereConnection(Path path) {
        FileSystem fileSystem = path.getFileSystem();
        OverthereConnection connection = null;
        if (fileSystem instanceof OverthereFileSystem) {
            connection = ((OverthereFileSystem)fileSystem).getConnection();
        } else if (fileSystem.equals(FileSystems.getDefault())) {
            connection = LocalConnection.getLocalConnection();
        } else {
            throw new IllegalArgumentException("FileSystem " + fileSystem + " is not supported for command execution.");
        }
        return connection;
    }

    private static CmdLine toCommandLine(Path path, String[] arguments) {
        CmdLine commandLine = CmdLine.build((String[])new String[]{path.toString()});
        for (String argument : arguments) {
            commandLine.addArgument(argument);
        }
        return commandLine;
    }
}

