/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.cache;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import java.util.Comparator;
import java.util.Map;

public final class QueryKeyExtractor
implements FilterExpressionVisitor<Object> {
    private static final char DELIMITER = ';';
    private static final char BEGIN_GROUP = '{';
    private static final char END_GROUP = '}';
    private static final int ESTIMATED_KEY_SIZE = 128;
    private final StringBuilder keyBuilder = new StringBuilder(128);

    private QueryKeyExtractor() {
    }

    public static String extractKey(Query query) {
        QueryKeyExtractor extractor = new QueryKeyExtractor();
        extractor.visit(query);
        return extractor.keyBuilder.toString();
    }

    private void visit(Query query) {
        this.visit(query.getSource());
        this.beginGroup();
        query.getMetricProjections().forEach(this::visit);
        this.endGroup();
        this.beginGroup();
        query.getDimensionProjections().stream().sorted(Comparator.comparing(ColumnProjection::getSafeAlias)).forEachOrdered(this::visit);
        this.endGroup();
        this.beginGroup();
        query.getTimeDimensionProjections().stream().sorted(Comparator.comparing(ColumnProjection::getSafeAlias)).forEachOrdered(this::visit);
        this.endGroup();
        this.visitExpression(query.getWhereFilter());
        this.visitExpression(query.getHavingFilter());
        this.visit(query.getSorting());
        this.visit(query.getPagination());
    }

    private void visit(Queryable source) {
        this.visit(source.getAlias());
    }

    private void visit(ColumnProjection columnProjection) {
        this.visit(columnProjection.getSafeAlias());
        this.visit(columnProjection.getArguments());
    }

    private void visit(Map<String, Argument> arguments) {
        this.beginGroup();
        arguments.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
            this.visit((String)e.getKey());
            this.visit(((Argument)e.getValue()).getName());
            this.visit(((Argument)e.getValue()).getValue().toString());
        });
        this.endGroup();
    }

    private void visit(Sorting sorting) {
        if (sorting == null) {
            this.keyBuilder.append(';');
            return;
        }
        this.beginGroup();
        this.visit(sorting.getType());
        sorting.getSortingPaths().forEach((path, order) -> {
            this.visit((Path)path);
            this.visit(order.toString());
        });
        this.endGroup();
    }

    private void visit(Path path) {
        this.beginGroup();
        path.getPathElements().forEach(this::visit);
        this.endGroup();
    }

    private void visit(Path.PathElement element) {
        this.beginGroup();
        this.visit(element.getType());
        this.visit(element.getFieldType());
        this.visit(element.getFieldName());
        this.endGroup();
    }

    private void visit(Pagination pagination) {
        if (pagination == null) {
            this.keyBuilder.append(';');
            return;
        }
        this.beginGroup();
        this.visit(pagination.getOffset());
        this.visit(pagination.getLimit());
        this.visit(pagination.returnPageTotals() ? "1" : "0");
        this.endGroup();
    }

    private void visitExpression(FilterExpression expr) {
        if (expr != null) {
            expr.accept((FilterExpressionVisitor)this);
        } else {
            this.keyBuilder.append(';');
        }
    }

    public Object visitPredicate(FilterPredicate filterPredicate) {
        this.beginGroup();
        this.visit("P");
        this.visit(filterPredicate.getPath());
        this.visit(filterPredicate.getOperator().toString());
        filterPredicate.getValues().forEach(this::visitObject);
        this.endGroup();
        return null;
    }

    public Object visitAndExpression(AndFilterExpression expression) {
        this.beginGroup();
        this.visit("A");
        expression.getLeft().accept((FilterExpressionVisitor)this);
        expression.getRight().accept((FilterExpressionVisitor)this);
        this.endGroup();
        return null;
    }

    public Object visitOrExpression(OrFilterExpression expression) {
        this.beginGroup();
        this.visit("O");
        expression.getLeft().accept((FilterExpressionVisitor)this);
        expression.getRight().accept((FilterExpressionVisitor)this);
        this.endGroup();
        return null;
    }

    public Object visitNotExpression(NotFilterExpression expression) {
        this.beginGroup();
        this.visit("N");
        expression.getNegated().accept((FilterExpressionVisitor)this);
        this.endGroup();
        return null;
    }

    private void visit(Type<?> type) {
        this.keyBuilder.append(type.getCanonicalName()).append(';');
    }

    private void visit(String string) {
        this.keyBuilder.append(string).append(';');
    }

    private void visit(int value) {
        this.keyBuilder.append(value).append(';');
    }

    private void visitObject(Object object) {
        String string = object.toString();
        this.keyBuilder.append(string.length()).append(';');
        this.keyBuilder.append(string).append(';');
    }

    private void beginGroup() {
        this.keyBuilder.append('{');
    }

    private void endGroup() {
        this.keyBuilder.append('}');
    }
}

