/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata;

import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ExpressionParser;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.Reference;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class FormulaValidator
extends ExpressionParser {
    private final LinkedHashSet<String> visited = new LinkedHashSet();

    private static String getColumnId(Queryable parent, ColumnProjection column) {
        return parent.getName() + "." + column.getName();
    }

    public FormulaValidator(MetaDataStore metaDataStore) {
        super(metaDataStore);
    }

    @Override
    public List<Reference> parse(Queryable source, ColumnProjection column) {
        String columnId = FormulaValidator.getColumnId(source, column);
        if (!this.visited.add(columnId)) {
            throw new IllegalArgumentException(FormulaValidator.referenceLoopMessage(this.visited, source, column));
        }
        List<Reference> references = this.parse(source, column.getExpression());
        this.visited.remove(columnId);
        return references;
    }

    private static String referenceLoopMessage(LinkedHashSet<String> visited, Queryable source, ColumnProjection conflict) {
        return "Formula reference loop found: " + visited.stream().collect(Collectors.joining("->")) + "->" + FormulaValidator.getColumnId(source, conflict);
    }
}

