/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.expression;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.core.JoinPath;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ColumnArgReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ExpressionParser;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.JoinReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.LogicalReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.PhysicalReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.Reference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ReferenceVisitor;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.TableArgReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLJoin;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class ReferenceExtractor<T extends Reference>
implements ReferenceVisitor<Set<T>> {
    private final Class<T> referenceType;
    private final Set<T> references;
    private MetaDataStore metaDataStore;
    private Set<SQLJoin> visitedJoins;
    private ExpressionParser parser;
    private Mode mode;

    public ReferenceExtractor(Class<T> referenceType, MetaDataStore metaDataStore) {
        this(referenceType, metaDataStore, Mode.ALL);
    }

    public ReferenceExtractor(Class<T> referenceType, MetaDataStore metaDataStore, Mode mode) {
        this.mode = mode;
        this.referenceType = referenceType;
        this.references = new LinkedHashSet<T>();
        this.metaDataStore = metaDataStore;
        this.parser = new ExpressionParser(metaDataStore);
        this.visitedJoins = new HashSet<SQLJoin>();
    }

    @Override
    public Set<T> visitPhysicalReference(PhysicalReference reference) {
        if (this.referenceType.equals(PhysicalReference.class)) {
            this.references.add(reference);
        }
        return this.references;
    }

    @Override
    public Set<T> visitLogicalReference(LogicalReference reference) {
        if (this.referenceType.equals(LogicalReference.class)) {
            this.references.add(reference);
        }
        if (this.mode != Mode.SAME_COLUMN) {
            reference.getReferences().stream().map(ref -> (Set)ref.accept(this)).flatMap(Collection::stream).forEach(this.references::add);
        }
        return this.references;
    }

    @Override
    public Set<T> visitJoinReference(JoinReference reference) {
        if (this.referenceType.equals(JoinReference.class)) {
            this.references.add(reference);
        }
        JoinPath path = reference.getPath();
        int pathLimit = this.mode == Mode.SAME_QUERY ? 1 : path.getPathElements().size() - 1;
        for (int idx = 0; idx < pathLimit; ++idx) {
            Path.PathElement pathElement = (Path.PathElement)path.getPathElements().get(idx);
            String fieldName = pathElement.getFieldName();
            Type parentClass = pathElement.getType();
            SQLTable table = (SQLTable)this.metaDataStore.getTable(parentClass);
            SQLJoin join = table.getJoin(fieldName);
            if (this.visitedJoins.contains(join)) continue;
            this.visitedJoins.add(join);
            this.parser.parse((Queryable)table, join.getJoinExpression()).stream().forEach(ref -> ref.accept(this));
        }
        if (this.mode != Mode.SAME_QUERY) {
            return (Set)reference.getReference().accept(this);
        }
        return this.references;
    }

    @Override
    public Set<T> visitColumnArgReference(ColumnArgReference reference) {
        if (this.referenceType.equals(ColumnArgReference.class)) {
            this.references.add(reference);
        }
        return this.references;
    }

    @Override
    public Set<T> visitTableArgReference(TableArgReference reference) {
        if (this.referenceType.equals(TableArgReference.class)) {
            this.references.add(reference);
        }
        return this.references;
    }

    public static enum Mode {
        ALL,
        SAME_QUERY,
        SAME_COLUMN;

    }
}

