/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.query;

import com.google.common.collect.Streams;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.DimensionProjection;
import com.yahoo.elide.datastores.aggregation.query.MetricProjection;
import com.yahoo.elide.datastores.aggregation.query.Optimizer;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.QueryVisitor;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.QueryPlanTranslator;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLColumnProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLTimeDimensionProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SubqueryFilterSplitter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class AggregateBeforeJoinOptimizer
implements Optimizer {
    private MetaDataStore metaDataStore;

    public AggregateBeforeJoinOptimizer(MetaDataStore metaDataStore) {
        this.metaDataStore = metaDataStore;
    }

    @Override
    public String hint() {
        return "AggregateBeforeJoin";
    }

    @Override
    public boolean canOptimize(Query query) {
        SubqueryFilterSplitter.SplitFilter splitFilter;
        if (query.isNested()) {
            return false;
        }
        if (!query.getColumnProjections().stream().allMatch(projection -> projection.canNest(query, this.metaDataStore))) {
            return false;
        }
        if (query.getWhereFilter() != null && (splitFilter = SubqueryFilterSplitter.splitFilter(this.metaDataStore, query.getWhereFilter())).getOuter() != null) {
            return true;
        }
        for (ColumnProjection column : query.getColumnProjections()) {
            boolean requiresJoin = SQLColumnProjection.requiresJoin(query.getSource(), column, this.metaDataStore);
            if (!requiresJoin) continue;
            return true;
        }
        return false;
    }

    @Override
    public Query optimize(Query query) {
        if (!this.canOptimize(query)) {
            return query;
        }
        return (Query)query.accept(new OptimizerVisitor());
    }

    private class OptimizerVisitor
    implements QueryVisitor<Queryable> {
        private OptimizerVisitor() {
        }

        @Override
        public Queryable visitQuery(Query query) {
            SubqueryFilterSplitter.SplitFilter splitWhere = SubqueryFilterSplitter.splitFilter(AggregateBeforeJoinOptimizer.this.metaDataStore, query.getWhereFilter());
            Set allProjections = Streams.concat((Stream[])new Stream[]{query.getColumnProjections().stream(), Queryable.extractFilterProjections(query, splitWhere.getOuter()).stream()}).collect(Collectors.toCollection(LinkedHashSet::new));
            Set allProjectionsNested = allProjections.stream().map(projection -> projection.nest(query, AggregateBeforeJoinOptimizer.this.metaDataStore, true)).collect(Collectors.toCollection(LinkedHashSet::new));
            Set allOuterProjections = allProjectionsNested.stream().map(Pair::getLeft).collect(Collectors.toCollection(LinkedHashSet::new));
            Set allInnerProjections = allProjectionsNested.stream().map(Pair::getRight).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
            Query.QueryBuilder inner = Query.builder().source(query.getSource().accept(this)).metricProjections(allInnerProjections.stream().filter(predicate -> predicate instanceof MetricProjection).map(MetricProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).dimensionProjections(allInnerProjections.stream().filter(predicate -> predicate instanceof DimensionProjection).map(DimensionProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).timeDimensionProjections(allInnerProjections.stream().filter(predicate -> predicate instanceof TimeDimensionProjection).map(SQLTimeDimensionProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).whereFilter(splitWhere.getInner());
            QueryPlanTranslator.addHiddenProjections(AggregateBeforeJoinOptimizer.this.metaDataStore, inner, query);
            Query outer = Query.builder().metricProjections(allOuterProjections.stream().filter(predicate -> predicate instanceof MetricProjection).map(MetricProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).dimensionProjections(allOuterProjections.stream().filter(predicate -> predicate instanceof DimensionProjection).map(DimensionProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).timeDimensionProjections(allOuterProjections.stream().filter(predicate -> predicate instanceof TimeDimensionProjection).map(TimeDimensionProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).whereFilter(splitWhere.getOuter()).havingFilter(query.getHavingFilter()).sorting(query.getSorting()).pagination(query.getPagination()).scope(query.getScope()).bypassingCache(query.isBypassingCache()).source(inner.build()).build();
            return outer;
        }

        @Override
        public Queryable visitQueryable(Queryable table) {
            return table;
        }
    }
}

