/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.query;

import com.google.common.collect.Streams;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.DefaultQueryPlanMerger;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.QueryPlan;
import com.yahoo.elide.datastores.aggregation.query.QueryPlanMerger;
import com.yahoo.elide.datastores.aggregation.query.QueryVisitor;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ExpressionParser;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.LogicalReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ReferenceExtractor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryPlanTranslator
implements QueryVisitor<Query.QueryBuilder> {
    private Query clientQuery;
    private boolean invoked = false;
    private MetaDataStore metaDataStore;
    private QueryPlanMerger merger;

    public QueryPlanTranslator(Query clientQuery, MetaDataStore metaDataStore, QueryPlanMerger merger) {
        this.metaDataStore = metaDataStore;
        this.clientQuery = clientQuery;
        this.merger = merger;
    }

    public QueryPlanTranslator(Query clientQuery, MetaDataStore metaDataStore) {
        this(clientQuery, metaDataStore, new DefaultQueryPlanMerger(metaDataStore));
    }

    public Query translate(QueryPlan plan) {
        QueryPlan clientQueryPlan = QueryPlan.builder().source(this.clientQuery.getSource()).timeDimensionProjections(this.clientQuery.getTimeDimensionProjections()).dimensionProjections(this.clientQuery.getDimensionProjections()).build();
        if (plan.isNested() && !clientQueryPlan.canNest(this.metaDataStore)) {
            throw new UnsupportedOperationException("Cannot nest one or more dimensions from the client query");
        }
        QueryPlan merged = this.merger.merge(clientQueryPlan, plan);
        return merged.accept(this).build();
    }

    @Override
    public Query.QueryBuilder visitQuery(Query query) {
        throw new UnsupportedOperationException("Visitor does not visit queries");
    }

    @Override
    public Query.QueryBuilder visitQueryable(Queryable plan) {
        if (!this.invoked) {
            this.invoked = true;
            if (plan.isNested()) {
                return this.visitOuterQueryPlan(plan);
            }
            return this.visitUnnestedQueryPlan(plan);
        }
        if (plan.isNested()) {
            return this.visitMiddleQueryPlan(plan);
        }
        return this.visitInnerQueryPlan(plan);
    }

    private Query.QueryBuilder visitInnerQueryPlan(Queryable plan) {
        Query.QueryBuilder builder = Query.builder().source(this.clientQuery.getSource()).metricProjections(plan.getMetricProjections()).dimensionProjections(plan.getDimensionProjections()).timeDimensionProjections(plan.getTimeDimensionProjections()).whereFilter(QueryPlanTranslator.mergeFilters(plan, this.clientQuery)).arguments(this.clientQuery.getArguments());
        return QueryPlanTranslator.addHiddenProjections(this.metaDataStore, builder, this.clientQuery);
    }

    private Query.QueryBuilder visitOuterQueryPlan(Queryable plan) {
        Query innerQuery = plan.getSource().accept(this).build();
        return Query.builder().source(innerQuery).metricProjections(plan.getMetricProjections()).dimensionProjections(plan.getDimensionProjections()).timeDimensionProjections(plan.getTimeDimensionProjections()).havingFilter(this.clientQuery.getHavingFilter()).sorting(this.clientQuery.getSorting()).pagination(this.clientQuery.getPagination()).scope(this.clientQuery.getScope()).arguments(this.clientQuery.getArguments());
    }

    private Query.QueryBuilder visitMiddleQueryPlan(Queryable plan) {
        Query innerQuery = plan.getSource().accept(this).build();
        return Query.builder().source(innerQuery).metricProjections(plan.getMetricProjections()).dimensionProjections(plan.getDimensionProjections()).timeDimensionProjections(plan.getTimeDimensionProjections());
    }

    private Query.QueryBuilder visitUnnestedQueryPlan(Queryable plan) {
        Query.QueryBuilder builder = Query.builder().source(this.clientQuery.getSource()).metricProjections(plan.getMetricProjections()).dimensionProjections(plan.getDimensionProjections()).timeDimensionProjections(plan.getTimeDimensionProjections()).havingFilter(this.clientQuery.getHavingFilter()).whereFilter(QueryPlanTranslator.mergeFilters(plan, this.clientQuery)).sorting(this.clientQuery.getSorting()).pagination(this.clientQuery.getPagination()).scope(this.clientQuery.getScope()).arguments(this.clientQuery.getArguments());
        return QueryPlanTranslator.addHiddenProjections(this.metaDataStore, builder, this.clientQuery);
    }

    public static Query.QueryBuilder addHiddenProjections(MetaDataStore metaDataStore, Query.QueryBuilder builder, Query query) {
        Set<ColumnProjection> directReferencedColumns = Streams.concat((Stream[])new Stream[]{query.getColumnProjections().stream(), query.getFilterProjections(query.getWhereFilter(), ColumnProjection.class).stream()}).collect(Collectors.toSet());
        ExpressionParser parser = new ExpressionParser(metaDataStore);
        HashSet indirectReferenceColumns = new HashSet();
        directReferencedColumns.forEach(column -> parser.parse(query.getSource(), (ColumnProjection)column).stream().map(reference -> (Set)((Object)reference.accept(new ReferenceExtractor<LogicalReference>(LogicalReference.class, metaDataStore, ReferenceExtractor.Mode.SAME_QUERY)))).flatMap(Collection::stream).map(LogicalReference::getColumn).forEach(indirectReferenceColumns::add));
        Streams.concat((Stream[])new Stream[]{directReferencedColumns.stream(), indirectReferenceColumns.stream()}).forEach(column -> {
            if (query.getColumnProjection(column.getAlias(), column.getArguments()) == null) {
                builder.column((ColumnProjection)column.withProjected(false));
            }
        });
        return builder;
    }

    public static Query.QueryBuilder addHiddenProjections(MetaDataStore metaDataStore, Query query) {
        Query.QueryBuilder builder = Query.builder().source(query.getSource()).metricProjections(query.getMetricProjections()).dimensionProjections(query.getDimensionProjections()).timeDimensionProjections(query.getTimeDimensionProjections()).havingFilter(query.getHavingFilter()).whereFilter(query.getWhereFilter()).sorting(query.getSorting()).pagination(query.getPagination()).scope(query.getScope()).arguments(query.getArguments());
        return QueryPlanTranslator.addHiddenProjections(metaDataStore, builder, query);
    }

    private static FilterExpression mergeFilters(Queryable a, Queryable b) {
        if (a.getWhereFilter() == null && b.getWhereFilter() == null) {
            return null;
        }
        if (a.getWhereFilter() == null) {
            return b.getWhereFilter();
        }
        if (b.getWhereFilter() == null) {
            return a.getWhereFilter();
        }
        return new AndFilterExpression(a.getWhereFilter(), b.getWhereFilter());
    }
}

