/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.query;

import com.yahoo.elide.datastores.aggregation.metadata.ColumnContext;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.PhysicalRefColumnContext;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite.SyntaxVerifier;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialect;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ColumnArgReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ExpressionParser;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.HasJoinVisitor;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.JoinReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.PhysicalReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.Reference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ReferenceExtractor;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLPhysicalColumnProjection;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SQLColumnProjection
extends ColumnProjection {
    public static final Logger LOGGER = LoggerFactory.getLogger(SQLColumnProjection.class);

    default public String toSQL(Queryable query, MetaDataStore metaDataStore) {
        ColumnContext context = ColumnContext.builder().queryable(query).alias(query.getSource().getAlias()).metaDataStore(metaDataStore).column(this).tableArguments(query.getArguments()).build();
        return context.resolve(this.getExpression());
    }

    default public String toPhysicalReferences(Queryable query, MetaDataStore metaDataStore) {
        PhysicalRefColumnContext context = PhysicalRefColumnContext.physicalRefContextBuilder().queryable(query).metaDataStore(metaDataStore).alias("").column(this).tableArguments(query.getArguments()).build();
        return context.resolve(this.getExpression());
    }

    @Override
    default public boolean canNest(Queryable source, MetaDataStore metaDataStore) {
        String sql;
        SQLDialect dialect = source.getConnectionDetails().getDialect();
        SyntaxVerifier verifier = new SyntaxVerifier(dialect);
        boolean canNest = verifier.verify(sql = this.toSQL(source, metaDataStore));
        if (!canNest) {
            LOGGER.debug("Unable to nest {} because {}", (Object)this.getName(), (Object)verifier.getLastError());
            return false;
        }
        List<Reference> references = new ExpressionParser(metaDataStore).parse(source, this);
        return references.stream().map(reference -> (Set)((Object)reference.accept(new ReferenceExtractor<JoinReference>(JoinReference.class, metaDataStore, ReferenceExtractor.Mode.SAME_QUERY)))).flatMap(Collection::stream).map(reference -> (Set)((Object)reference.accept(new ReferenceExtractor<ColumnArgReference>(ColumnArgReference.class, metaDataStore)))).flatMap(Collection::stream).collect(Collectors.toSet()).isEmpty();
    }

    @Override
    default public Pair<ColumnProjection, Set<ColumnProjection>> nest(Queryable source, MetaDataStore store, boolean joinInOuter) {
        Set<ColumnProjection> innerProjections;
        Object outerProjection;
        boolean inProjection;
        List<Reference> references = new ExpressionParser(store).parse(source, this.getExpression());
        boolean requiresJoin = SQLColumnProjection.requiresJoin(references);
        String columnId = source.isRoot() ? this.getName() : this.getAlias();
        boolean bl = inProjection = source.getColumnProjection(columnId, this.getArguments(), true) != null;
        if (requiresJoin && joinInOuter) {
            String outerProjectionExpression = this.toPhysicalReferences(source, store);
            outerProjection = this.withExpression(outerProjectionExpression, inProjection);
            innerProjections = SQLColumnProjection.extractPhysicalReferences(source, references, store);
        } else {
            outerProjection = this.withExpression("{{$" + this.getSafeAlias() + "}}", this.isProjected());
            innerProjections = new LinkedHashSet<SQLColumnProjection>(Arrays.asList(this));
        }
        return Pair.of(outerProjection, innerProjections);
    }

    public <T extends ColumnProjection> T withExpression(String var1, boolean var2);

    public static boolean requiresJoin(Queryable source, ColumnProjection projection, MetaDataStore store) {
        List<Reference> references = new ExpressionParser(store).parse(source, projection.getExpression());
        return SQLColumnProjection.requiresJoin(references);
    }

    public static boolean requiresJoin(List<Reference> references) {
        return references.stream().anyMatch(ref -> ref.accept(new HasJoinVisitor()));
    }

    public static Set<ColumnProjection> extractPhysicalReferences(Queryable source, List<Reference> references, MetaDataStore store) {
        return references.stream().map(ref -> (Set)((Object)ref.accept(new ReferenceExtractor<PhysicalReference>(PhysicalReference.class, store, ReferenceExtractor.Mode.SAME_QUERY)))).flatMap(Collection::stream).map(ref -> SQLPhysicalColumnProjection.builder().name(ref.getName()).build()).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

