/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.timegrains;

import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import com.yahoo.elide.datastores.aggregation.timegrains.Time;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class Week
extends Time {
    public static final String FORMAT = "yyyy-MM-dd";

    public Week(LocalDateTime date) {
        super(date, true, true, true, false, false, false, Week.getSerializer(TimeGrain.WEEK));
    }

    @ElideTypeConverter(type=Week.class, name="Week")
    public static class WeekSerde
    implements Serde<Object, Week> {
        public Week deserialize(Object val) {
            LocalDateTime date;
            if (val instanceof Date) {
                date = LocalDateTime.ofInstant(((Date)val).toInstant(), ZoneOffset.systemDefault());
            } else if (val instanceof OffsetDateTime) {
                OffsetDateTime offsetDateTime = (OffsetDateTime)val;
                date = offsetDateTime.toLocalDate().atTime(0, 0);
            } else {
                LocalDate localDate = LocalDate.parse(val.toString(), DateTimeFormatter.ISO_LOCAL_DATE);
                date = localDate.atTime(0, 0);
            }
            if (date.getDayOfWeek() != DayOfWeek.SUNDAY) {
                throw new IllegalArgumentException("Date string not a Sunday");
            }
            return new Week(date);
        }

        public String serialize(Week val) {
            return val.serializer.format(val);
        }
    }
}

