/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpql;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreIterableBuilder;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.predicates.FalsePredicate;
import com.yahoo.elide.core.filter.predicates.InPredicate;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TimedFunction;
import com.yahoo.elide.datastores.jpql.porting.Query;
import com.yahoo.elide.datastores.jpql.porting.ScrollableIteratorBase;
import com.yahoo.elide.datastores.jpql.porting.Session;
import com.yahoo.elide.datastores.jpql.query.AbstractHQLQueryBuilder;
import com.yahoo.elide.datastores.jpql.query.RelationshipImpl;
import com.yahoo.elide.datastores.jpql.query.RootCollectionFetchQueryBuilder;
import com.yahoo.elide.datastores.jpql.query.RootCollectionPageTotalsQueryBuilder;
import com.yahoo.elide.datastores.jpql.query.SubCollectionFetchQueryBuilder;
import com.yahoo.elide.datastores.jpql.query.SubCollectionPageTotalsQueryBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

public abstract class JPQLTransaction
implements DataStoreTransaction {
    private final Session sessionWrapper;
    private final boolean isScrollEnabled;
    private final Set<Object> singleElementLoads;
    private final boolean delegateToInMemoryStore;

    protected JPQLTransaction(Session session, boolean delegateToInMemoryStore, boolean isScrollEnabled) {
        this.sessionWrapper = session;
        this.isScrollEnabled = isScrollEnabled;
        this.singleElementLoads = Collections.newSetFromMap(new IdentityHashMap());
        this.delegateToInMemoryStore = delegateToInMemoryStore;
    }

    public <T> T loadObject(EntityProjection projection, Serializable id, RequestScope scope) {
        Type entityClass = projection.getType();
        FilterExpression filterExpression = projection.getFilterExpression();
        EntityDictionary dictionary = scope.getDictionary();
        Type idType = dictionary.getIdType(entityClass);
        String idField = dictionary.getIdFieldName(entityClass);
        Path.PathElement idPath = new Path.PathElement(entityClass, idType, idField);
        Object idExpression = id != null ? new InPredicate(idPath, (Object[])new Serializable[]{id}) : new FalsePredicate(idPath);
        FalsePredicate joinedExpression = filterExpression != null ? new AndFilterExpression(filterExpression, (FilterExpression)idExpression) : idExpression;
        Query query = new RootCollectionFetchQueryBuilder(projection = projection.copyOf().filterExpression((FilterExpression)joinedExpression).build(), dictionary, this.sessionWrapper).build();
        Object loaded = new TimedFunction(() -> query.uniqueResult(), "Query Hash: " + query.hashCode()).get();
        if (loaded != null) {
            this.singleElementLoads.add(loaded);
        }
        return (T)loaded;
    }

    public <T> DataStoreIterable<T> loadObjects(EntityProjection projection, RequestScope scope) {
        Pagination pagination = projection.getPagination();
        Query query = new RootCollectionFetchQueryBuilder(projection, scope.getDictionary(), this.sessionWrapper).build();
        Iterable results = (Iterable)new TimedFunction(() -> this.isScrollEnabled ? query.scroll() : query.list(), "Query Hash: " + query.hashCode()).get();
        boolean hasResults = results instanceof Collection ? !((Collection)results).isEmpty() : (results instanceof Iterator ? ((Iterator)((Object)results)).hasNext() : results.iterator().hasNext());
        if (pagination != null && pagination.returnPageTotals() && (hasResults || pagination.getLimit() == 0)) {
            pagination.setPageTotals(this.getTotalRecords(projection, scope.getDictionary()));
        }
        return new DataStoreIterableBuilder(this.addSingleElement(results)).build();
    }

    public <T, R> DataStoreIterable<R> getToManyRelation(DataStoreTransaction relationTx, T entity, Relationship relation, RequestScope scope) {
        FilterExpression filterExpression = relation.getProjection().getFilterExpression();
        Sorting sorting = relation.getProjection().getSorting();
        Pagination pagination = relation.getProjection().getPagination();
        EntityDictionary dictionary = scope.getDictionary();
        Iterable val = (Iterable)PersistentResource.getValue(entity, (String)relation.getName(), (RequestScope)scope);
        if (this.doInDatabase(entity) && val instanceof Collection && this.isPersistentCollection().test((Collection)val)) {
            Query query;
            if (filterExpression == null && sorting == null && (pagination == null || pagination.isDefaultInstance())) {
                return new DataStoreIterableBuilder(this.addSingleElement(val)).allInMemory().build();
            }
            RelationshipImpl relationship = new RelationshipImpl(dictionary.lookupEntityClass(EntityDictionary.getType(entity)), entity, relation);
            if (pagination != null && pagination.returnPageTotals()) {
                pagination.setPageTotals(this.getTotalRecords(relationship, scope.getDictionary()));
            }
            if ((query = new SubCollectionFetchQueryBuilder(relationship, dictionary, this.sessionWrapper).build()) != null) {
                return new DataStoreIterableBuilder(this.addSingleElement(query.list())).build();
            }
        }
        return new DataStoreIterableBuilder(this.addSingleElement(val)).allInMemory().build();
    }

    public <T, R> R getToOneRelation(DataStoreTransaction relationTx, T entity, Relationship relationship, RequestScope scope) {
        Object loaded = super.getToOneRelation(relationTx, entity, relationship, scope);
        if (loaded != null) {
            this.singleElementLoads.add(loaded);
        }
        return (R)loaded;
    }

    protected abstract Predicate<Collection<?>> isPersistentCollection();

    private Long getTotalRecords(EntityProjection entityProjection, EntityDictionary dictionary) {
        Query query = new RootCollectionPageTotalsQueryBuilder(entityProjection, dictionary, this.sessionWrapper).build();
        return (Long)new TimedFunction(() -> (Long)query.uniqueResult(), "Query Hash: " + query.hashCode()).get();
    }

    private Long getTotalRecords(AbstractHQLQueryBuilder.Relationship relationship, EntityDictionary dictionary) {
        Query query = new SubCollectionPageTotalsQueryBuilder(relationship, dictionary, this.sessionWrapper).build();
        return (Long)new TimedFunction(() -> (Long)query.uniqueResult(), "Query Hash: " + query.hashCode()).get();
    }

    private <R> Iterable<R> addSingleElement(Iterable<R> results) {
        if (results instanceof ScrollableIteratorBase) {
            ((ScrollableIteratorBase)results).singletonElement().ifPresent(this.singleElementLoads::add);
        } else if (results instanceof Collection && ((Collection)results).size() == 1) {
            ((Collection)results).forEach(this.singleElementLoads::add);
        }
        return results;
    }

    protected <T> boolean doInDatabase(T parent) {
        return !this.delegateToInMemoryStore || this.singleElementLoads.contains(parent);
    }
}

