/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpql.filter;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.datastores.jpql.filter.JPQLPredicateGenerator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseAwareJPQLGenerator
implements JPQLPredicateGenerator {
    private static final Logger log = LoggerFactory.getLogger(CaseAwareJPQLGenerator.class);
    private static final String COMMA = ", ";
    private static final String FILTER_PATH_NOT_NULL = "Filtering field path cannot be empty.";
    private static final String FILTER_ALIAS_NOT_NULL = "Filtering alias cannot be empty.";
    private Case upperOrLower;
    private String jpqlTemplate;
    private ArgumentCount argumentCount;

    public CaseAwareJPQLGenerator(String jpqlTemplate, Case upperOrLower, ArgumentCount argumentCount) {
        this.upperOrLower = upperOrLower;
        this.jpqlTemplate = jpqlTemplate;
        this.argumentCount = argumentCount;
    }

    @Override
    public String generate(FilterPredicate predicate, Function<Path, String> aliasGenerator) {
        String columnAlias = aliasGenerator.apply(predicate.getPath());
        List parameters = predicate.getParameters();
        if (StringUtils.isEmpty((CharSequence)columnAlias)) {
            log.error("columnAlias cannot be NULL or empty");
            throw new InvalidValueException((Object)FILTER_PATH_NOT_NULL);
        }
        if (this.argumentCount == ArgumentCount.MANY) {
            Preconditions.checkState((!parameters.isEmpty() ? 1 : 0) != 0);
        } else if (this.argumentCount == ArgumentCount.ONE) {
            Preconditions.checkArgument((parameters.size() == 1 ? 1 : 0) != 0);
            if (StringUtils.isEmpty((CharSequence)((FilterPredicate.FilterParameter)parameters.get(0)).getPlaceholder())) {
                log.error("One non-null, non-empty argument was expected.");
                throw new IllegalStateException(FILTER_ALIAS_NOT_NULL);
            }
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = this.upperOrLower.wrap(columnAlias);
        objectArray[1] = parameters.stream().map(this.upperOrLower::wrap).collect(Collectors.joining(COMMA));
        return String.format(this.jpqlTemplate, objectArray);
    }

    public static enum ArgumentCount {
        ZERO,
        ONE,
        MANY;

    }

    public static enum Case {
        LOWER,
        UPPER,
        NONE;


        public String wrap(String toWrap) {
            if (this.equals((Object)NONE)) {
                return toWrap;
            }
            return String.format("%s(%s)", this.name(), toWrap);
        }

        public String wrap(FilterPredicate.FilterParameter toWrap) {
            return this.wrap(toWrap.getPlaceholder());
        }
    }
}

