/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpql.query;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.datastores.jpql.filter.FilterTranslator;
import com.yahoo.elide.datastores.jpql.porting.Query;
import com.yahoo.elide.datastores.jpql.porting.Session;
import com.yahoo.elide.datastores.jpql.query.AbstractHQLQueryBuilder;
import java.util.Collection;

public class RootCollectionFetchQueryBuilder
extends AbstractHQLQueryBuilder {
    public RootCollectionFetchQueryBuilder(EntityProjection entityProjection, EntityDictionary dictionary, Session session) {
        super(entityProjection, dictionary, session);
    }

    @Override
    public Query build() {
        Query query;
        Type entityClass = this.entityProjection.getType();
        String entityName = entityClass.getCanonicalName();
        String entityAlias = TypeHelper.getTypeAlias((Type)entityClass);
        FilterExpression filterExpression = this.entityProjection.getFilterExpression();
        if (filterExpression != null) {
            boolean sortOverRelationship;
            PredicateExtractionVisitor extractor = new PredicateExtractionVisitor();
            Collection predicates = (Collection)filterExpression.accept((FilterExpressionVisitor)extractor);
            String filterClause = " WHERE " + new FilterTranslator(this.dictionary).apply(filterExpression, true);
            String joinClause = this.getJoinClauseFromFilters(filterExpression) + this.getJoinClauseFromSort(this.entityProjection.getSorting()) + this.extractToOneMergeJoins(entityClass, entityAlias);
            boolean requiresDistinct = this.entityProjection.getPagination() != null && this.containsOneToMany(filterExpression);
            boolean bl = sortOverRelationship = this.entityProjection.getSorting() != null && this.entityProjection.getSorting().getSortingPaths().keySet().stream().anyMatch(path -> path.getPathElements().size() > 1);
            if (requiresDistinct && sortOverRelationship) {
                throw new InvalidValueException((Object)"Combination of pagination, sorting over relationship and filtering over toMany relationships unsupported");
            }
            query = this.session.createQuery("SELECT " + (requiresDistinct ? "DISTINCT " : "") + entityAlias + " FROM " + entityName + " AS " + entityAlias + " " + joinClause + " " + filterClause + " " + this.getSortClause(this.entityProjection.getSorting()));
            this.supplyFilterQueryParameters(query, predicates);
        } else {
            query = this.session.createQuery("SELECT " + entityAlias + " FROM " + entityName + " AS " + entityAlias + " " + this.getJoinClauseFromSort(this.entityProjection.getSorting()) + this.extractToOneMergeJoins(entityClass, entityAlias) + " " + this.getSortClause(this.entityProjection.getSorting()));
        }
        this.addPaginationToQuery(query);
        return query;
    }
}

