/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jms;

import com.google.gson.Gson;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.type.Type;
import java.util.function.Function;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class MessageDeserializer<T>
implements Function<Message, T> {
    private Type<?> type;
    private Gson gson;

    public MessageDeserializer(Type<?> type, Gson gson) {
        this.type = type;
        this.gson = gson;
    }

    @Override
    public T apply(Message message) {
        try {
            return (T)this.gson.fromJson(((TextMessage)message).getText(), (Class)this.type.getUnderlyingClass().get());
        }
        catch (JMSException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }
}

