/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.noop;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopTransaction
implements DataStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(NoopTransaction.class);

    public void save(Object entity, RequestScope scope) {
    }

    public void delete(Object entity, RequestScope scope) {
    }

    public void flush(RequestScope scope) {
    }

    public void commit(RequestScope scope) {
    }

    public void createObject(Object entity, RequestScope scope) {
    }

    public Object loadObject(Class<?> entityClass, Serializable id, Optional<FilterExpression> filterExpression, RequestScope scope) {
        Object entity;
        try {
            entity = entityClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Could not load object {} through NoopStore", entityClass, (Object)e);
            throw new RuntimeException(e);
        }
        String uuid = scope.getUUIDFor(entity);
        new PersistentResource(entity, uuid, scope).setId(id.toString());
        return entity;
    }

    public Iterable<Object> loadObjects(Class<?> entityClass, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        return Collections.singletonList(this.loadObject(entityClass, Long.valueOf(1L), filterExpression, scope));
    }

    public void close() throws IOException {
    }
}

