/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.swagger;

import com.fasterxml.jackson.databind.type.SimpleType;
import com.google.common.base.Preconditions;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.swagger.model.Resource;
import com.yahoo.elide.swagger.property.Relationship;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.jackson.ModelResolver;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class JsonApiModelResolver
extends ModelResolver {
    private final EntityDictionary dictionary;

    public JsonApiModelResolver(EntityDictionary dictionary) {
        super(Json.mapper());
        this.dictionary = dictionary;
    }

    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> next) {
        String typeAlias;
        if (!(type instanceof Class || type instanceof SimpleType || type instanceof com.yahoo.elide.core.type.Type)) {
            return super.resolve(type, context, next);
        }
        com.yahoo.elide.core.type.Type clazzType = null;
        if (type instanceof SimpleType) {
            type = ((SimpleType)type).getRawClass();
            clazzType = ClassType.of((Class)((Class)type));
        } else if (type instanceof com.yahoo.elide.core.type.Type) {
            clazzType = (com.yahoo.elide.core.type.Type)type;
        } else if (type instanceof Class) {
            clazzType = ClassType.of((Class)((Class)type));
        }
        try {
            typeAlias = this.dictionary.getJsonAliasFor(clazzType);
        }
        catch (IllegalArgumentException e) {
            return super.resolve(type, context, next);
        }
        Resource entitySchema = new Resource();
        entitySchema.description(this.getModelDescription(clazzType));
        entitySchema.setSecurityDescription(this.getClassPermissions(clazzType));
        List attributeNames = this.dictionary.getAttributes(clazzType);
        for (String attributeName : attributeNames) {
            com.yahoo.elide.core.type.Type attributeType = this.dictionary.getType(clazzType, attributeName);
            Property attribute = this.processAttribute(clazzType, attributeName, attributeType, context, next);
            entitySchema.addAttribute(attributeName, attribute);
        }
        List relationshipNames = this.dictionary.getRelationships(clazzType);
        for (String relationshipName : relationshipNames) {
            com.yahoo.elide.core.type.Type relationshipType;
            Relationship relationship = this.processRelationship(clazzType, relationshipName, relationshipType = this.dictionary.getParameterizedType(clazzType, relationshipName));
            if (relationship == null) continue;
            entitySchema.addRelationship(relationshipName, (Property)relationship);
        }
        entitySchema.name(typeAlias);
        return entitySchema;
    }

    private Property processAttribute(com.yahoo.elide.core.type.Type<?> clazzType, String attributeName, com.yahoo.elide.core.type.Type<?> attributeType, ModelConverterContext context, Iterator<ModelConverter> next) {
        Preconditions.checkState((boolean)(attributeType instanceof ClassType));
        Property attribute = super.resolveProperty((Type)((ClassType)attributeType).getCls(), context, null, next);
        String permissions = this.getFieldPermissions(clazzType, attributeName);
        String description = this.getFieldDescription(clazzType, attributeName);
        attribute.setDescription((String)StringUtils.defaultIfEmpty((CharSequence)this.joinNonEmpty("\n", description, permissions), null));
        attribute.setExample((Object)StringUtils.defaultIfEmpty((CharSequence)this.getFieldExample(clazzType, attributeName), null));
        attribute.setReadOnly(Boolean.valueOf(this.getFieldReadOnly(clazzType, attributeName)));
        attribute.setRequired(this.getFieldRequired(clazzType, attributeName));
        return attribute;
    }

    private Relationship processRelationship(com.yahoo.elide.core.type.Type<?> clazz, String relationshipName, com.yahoo.elide.core.type.Type<?> relationshipClazz) {
        Relationship relationship = null;
        try {
            relationship = new Relationship(this.dictionary.getJsonAliasFor(relationshipClazz));
        }
        catch (IllegalArgumentException e) {
            return relationship;
        }
        String description = this.getFieldDescription(clazz, relationshipName);
        String permissions = this.getFieldPermissions(clazz, relationshipName);
        relationship.setDescription((String)StringUtils.defaultIfEmpty((CharSequence)this.joinNonEmpty("\n", description, permissions), null));
        relationship.setExample(StringUtils.defaultIfEmpty((CharSequence)this.getFieldExample(clazz, relationshipName), null));
        relationship.setReadOnly(this.getFieldReadOnly(clazz, relationshipName));
        relationship.setRequired(this.getFieldRequired(clazz, relationshipName));
        return relationship;
    }

    private ApiModel getApiModel(com.yahoo.elide.core.type.Type<?> clazz) {
        return (ApiModel)this.dictionary.getAnnotation(clazz, ApiModel.class);
    }

    private String getModelDescription(com.yahoo.elide.core.type.Type<?> clazz) {
        ApiModel model = this.getApiModel(clazz);
        if (model == null) {
            String description = EntityDictionary.getEntityDescription(clazz);
            if (StringUtils.isEmpty((CharSequence)description)) {
                return null;
            }
            return description;
        }
        return model.description();
    }

    private ApiModelProperty getApiModelProperty(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        return (ApiModelProperty)this.dictionary.getAttributeOrRelationAnnotation(clazz, ApiModelProperty.class, fieldName);
    }

    private boolean getFieldRequired(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        ApiModelProperty property = this.getApiModelProperty(clazz, fieldName);
        return property != null && property.required();
    }

    private boolean getFieldReadOnly(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        ApiModelProperty property = this.getApiModelProperty(clazz, fieldName);
        return property != null && property.readOnly();
    }

    private String getFieldExample(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        ApiModelProperty property = this.getApiModelProperty(clazz, fieldName);
        return property == null ? "" : property.example();
    }

    private String getFieldDescription(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        ApiModelProperty property = this.getApiModelProperty(clazz, fieldName);
        return property == null ? "" : property.value();
    }

    protected String getClassPermissions(com.yahoo.elide.core.type.Type<?> clazz) {
        Object createPermissions = this.getCreatePermission(clazz);
        Object deletePermissions = this.getDeletePermission(clazz);
        createPermissions = createPermissions == null ? "" : "Create Permissions : (" + (String)createPermissions + ")";
        deletePermissions = deletePermissions == null ? "" : "Delete Permissions : (" + (String)deletePermissions + ")";
        return this.joinNonEmpty("\n", new String[]{createPermissions, deletePermissions});
    }

    private String joinNonEmpty(String delimiter, String ... elements) {
        return Arrays.stream(elements).filter(StringUtils::isNotBlank).collect(Collectors.joining(delimiter));
    }

    protected String getFieldPermissions(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        Object readPermissions = this.getReadPermission(clazz, fieldName);
        Object updatePermissions = this.getUpdatePermission(clazz, fieldName);
        readPermissions = readPermissions == null ? "" : "Read Permissions : (" + (String)readPermissions + ")";
        updatePermissions = updatePermissions == null ? "" : "Update Permissions : (" + (String)updatePermissions + ")";
        return this.joinNonEmpty("\n", new String[]{readPermissions, updatePermissions});
    }

    protected String getReadPermission(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        ReadPermission classPermission = (ReadPermission)this.dictionary.getAnnotation(clazz, ReadPermission.class);
        ReadPermission fieldPermission = (ReadPermission)this.dictionary.getAttributeOrRelationAnnotation(clazz, ReadPermission.class, fieldName);
        if (fieldPermission != null) {
            return fieldPermission.expression();
        }
        if (classPermission != null) {
            return classPermission.expression();
        }
        return null;
    }

    protected String getUpdatePermission(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        UpdatePermission classPermission = (UpdatePermission)this.dictionary.getAnnotation(clazz, UpdatePermission.class);
        UpdatePermission fieldPermission = (UpdatePermission)this.dictionary.getAttributeOrRelationAnnotation(clazz, UpdatePermission.class, fieldName);
        if (fieldPermission != null) {
            return fieldPermission.expression();
        }
        if (classPermission != null) {
            return classPermission.expression();
        }
        return null;
    }

    protected String getCreatePermission(com.yahoo.elide.core.type.Type<?> clazz) {
        CreatePermission classPermission = (CreatePermission)this.dictionary.getAnnotation(clazz, CreatePermission.class);
        if (classPermission != null) {
            return classPermission.expression();
        }
        return null;
    }

    protected String getDeletePermission(com.yahoo.elide.core.type.Type<?> clazz) {
        DeletePermission classPermission = (DeletePermission)this.dictionary.getAnnotation(clazz, DeletePermission.class);
        if (classPermission != null) {
            return classPermission.expression();
        }
        return null;
    }
}

