/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.swagger;

import com.google.common.collect.Sets;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.swagger.JsonApiModelResolver;
import com.yahoo.elide.swagger.JsonApiOperation;
import com.yahoo.elide.swagger.model.Data;
import com.yahoo.elide.swagger.property.Datum;
import com.yahoo.elide.swagger.property.Relationship;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContextImpl;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class SwaggerBuilder {
    protected EntityDictionary dictionary;
    protected Set<com.yahoo.elide.core.type.Type<?>> rootClasses;
    protected Set<com.yahoo.elide.core.type.Type<?>> allClasses;
    protected Swagger swagger;
    protected Map<Integer, Response> globalResponses;
    protected Set<Parameter> globalParams;
    protected Set<Operator> filterOperators;
    protected boolean supportLegacyDialect;
    protected boolean supportRSQLDialect;
    public static final Response UNAUTHORIZED_RESPONSE = new Response().description("Unauthorized");
    public static final Response FORBIDDEN_RESPONSE = new Response().description("Forbidden");
    public static final Response NOT_FOUND_RESPONSE = new Response().description("Not Found");
    public static final Response REQUEST_TIMEOUT_RESPONSE = new Response().description("Request Timeout");
    public static final Response TOO_MANY_REQUESTS_RESPONSE = new Response().description("Too Many Requests");

    public SwaggerBuilder(EntityDictionary dictionary, Info info) {
        this.dictionary = dictionary;
        this.supportLegacyDialect = true;
        this.supportRSQLDialect = true;
        this.globalResponses = new HashMap<Integer, Response>();
        this.globalParams = new HashSet<Parameter>();
        this.allClasses = new HashSet();
        this.filterOperators = Sets.newHashSet((Object[])new Operator[]{Operator.IN, Operator.NOT, Operator.INFIX, Operator.PREFIX, Operator.POSTFIX, Operator.GE, Operator.GT, Operator.LE, Operator.LT, Operator.ISNULL, Operator.NOTNULL});
        this.swagger = new Swagger();
        this.swagger.info(info);
    }

    public SwaggerBuilder withGlobalResponse(int code, Response response) {
        this.globalResponses.put(code, response);
        return this;
    }

    public SwaggerBuilder withLegacyFilterDialect(boolean enableLegacyDialect) {
        this.supportLegacyDialect = enableLegacyDialect;
        return this;
    }

    public SwaggerBuilder withRSQLFilterDialect(boolean enableRSQLDialect) {
        this.supportRSQLDialect = enableRSQLDialect;
        return this;
    }

    public SwaggerBuilder withGlobalParameter(Parameter param) {
        this.globalParams.add(param);
        return this;
    }

    public SwaggerBuilder withExplicitClassList(Set<com.yahoo.elide.core.type.Type<?>> classes) {
        this.allClasses = new HashSet(classes);
        return this;
    }

    public SwaggerBuilder withFilterOps(Set<Operator> ops) {
        this.filterOperators = new HashSet<Operator>(ops);
        return this;
    }

    public Swagger build() {
        ModelConverters converters = ModelConverters.getInstance();
        JsonApiModelResolver converter = new JsonApiModelResolver(this.dictionary);
        converters.addConverter((ModelConverter)converter);
        String apiVersion = this.swagger.getInfo().getVersion();
        if (apiVersion == null) {
            apiVersion = "";
        }
        if (this.allClasses.isEmpty()) {
            this.allClasses = this.dictionary.getBoundClassesByVersion(apiVersion);
        } else {
            this.allClasses = Sets.intersection((Set)this.dictionary.getBoundClassesByVersion(apiVersion), this.allClasses);
            if (this.allClasses.isEmpty()) {
                throw new IllegalArgumentException("None of the provided classes are exported by Elide");
            }
        }
        HashMap models = new HashMap();
        for (com.yahoo.elide.core.type.Type<?> clazz2 : this.allClasses) {
            if (clazz2 instanceof ClassType) {
                models.putAll(converters.readAll((Type)((ClassType)clazz2).getCls()));
                continue;
            }
            ModelConverterContextImpl context = new ModelConverterContextImpl(Arrays.asList(new ModelConverter[]{converter}));
            context.resolve(clazz2);
            models.putAll(context.getDefinedModels());
        }
        this.swagger.setDefinitions(models);
        this.rootClasses = this.allClasses.stream().filter(arg_0 -> ((EntityDictionary)this.dictionary).isRoot(arg_0)).collect(Collectors.toSet());
        Sets.SetView pathData = this.rootClasses.stream().map(this::find).flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet toRemove = new HashSet();
        pathData.stream().collect(Collectors.groupingBy(PathMetaData::getRootType)).values().forEach(pathSet -> {
            block0: for (PathMetaData path : pathSet) {
                for (PathMetaData compare : pathSet) {
                    if (compare.lineage.isEmpty() || path == compare || !compare.shorterThan(path)) continue;
                    toRemove.add(path);
                    continue block0;
                }
            }
        });
        pathData = Sets.difference(pathData, toRemove);
        for (PathMetaData pathDatum : pathData) {
            this.swagger.path(pathDatum.getCollectionUrl(), pathDatum.getCollectionPath());
            this.swagger.path(pathDatum.getUrl(), pathDatum.getInstancePath());
            if (pathDatum.lineage.isEmpty()) continue;
            this.swagger.path(pathDatum.getRelationshipUrl(), pathDatum.getRelationshipPath());
        }
        List tags = this.allClasses.stream().map(clazz -> this.dictionary.getJsonAliasFor(clazz)).map(alias -> new Tag().name(alias)).collect(Collectors.toList());
        this.swagger.tags(tags);
        return this.swagger;
    }

    protected Set<PathMetaData> find(com.yahoo.elide.core.type.Type<?> rootClass) {
        ArrayDeque<PathMetaData> toVisit = new ArrayDeque<PathMetaData>();
        HashSet<PathMetaData> paths = new HashSet<PathMetaData>();
        toVisit.add(new PathMetaData(rootClass));
        while (!toVisit.isEmpty()) {
            List relationshipNames;
            PathMetaData current = (PathMetaData)toVisit.remove();
            try {
                relationshipNames = this.dictionary.getRelationships(current.getType());
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            for (String relationshipName : relationshipNames) {
                com.yahoo.elide.core.type.Type relationshipClass = this.dictionary.getParameterizedType(current.getType(), relationshipName);
                PathMetaData next = new PathMetaData(current.getFullLineage(), relationshipName, relationshipClass);
                if (current.lineageContainsType(next) || !this.allClasses.contains(relationshipClass)) continue;
                toVisit.add(next);
            }
            paths.add(current);
        }
        return paths;
    }

    public static String getDocument(Swagger swagger) {
        return Json.pretty((Object)swagger);
    }

    public class PathMetaData {
        private Stack<PathMetaData> lineage;
        private String name;
        private com.yahoo.elide.core.type.Type<?> type;
        private String url;

        public PathMetaData(com.yahoo.elide.core.type.Type<?> type) {
            this(new Stack<PathMetaData>(), this$0.dictionary.getJsonAliasFor(type), type);
        }

        public PathMetaData(Stack<PathMetaData> lineage, String name, com.yahoo.elide.core.type.Type<?> type) {
            this.lineage = lineage;
            this.type = type;
            this.name = name;
            this.url = this.constructInstanceUrl();
        }

        public com.yahoo.elide.core.type.Type<?> getRootType() {
            if (this.lineage.isEmpty()) {
                return this.type;
            }
            return ((PathMetaData)this.lineage.elementAt((int)0)).type;
        }

        public String getCollectionUrl() {
            if (this.lineage.isEmpty()) {
                return "/" + this.name;
            }
            return this.lineage.peek().getUrl() + "/" + this.name;
        }

        private String constructInstanceUrl() {
            String typeName = SwaggerBuilder.this.dictionary.getJsonAliasFor(this.type);
            return this.getCollectionUrl() + "/{" + typeName + "Id}";
        }

        public String getRelationshipUrl() {
            if (this.lineage.isEmpty()) {
                throw new IllegalStateException("Root collections don't have relationships");
            }
            PathMetaData prior = this.lineage.peek();
            String baseUrl = prior.getUrl();
            return baseUrl + "/relationships/" + this.name;
        }

        public String toString() {
            return this.getUrl();
        }

        private String getTag() {
            return SwaggerBuilder.this.dictionary.getJsonAliasFor(this.type);
        }

        private Parameter getPathParameter() {
            String typeName = SwaggerBuilder.this.dictionary.getJsonAliasFor(this.type);
            AbstractSerializableParameter param = ((PathParameter)((PathParameter)new PathParameter().name(typeName + "Id")).description(typeName + " Identifier")).property((Property)new StringProperty());
            return param;
        }

        public Path getRelationshipPath() {
            if (this.lineage.isEmpty()) {
                throw new IllegalStateException("Root collections don't have relationships");
            }
            Path path = new Path();
            this.lineage.stream().forEach(item -> path.addParameter(item.getPathParameter()));
            String typeName = SwaggerBuilder.this.dictionary.getJsonAliasFor(this.type);
            Response okSingularResponse = new Response().description("Successful response").schema((Property)new Datum(new Relationship(typeName)));
            Response okPluralResponse = new Response().description("Successful response").schema((Property)new com.yahoo.elide.swagger.property.Data(new Relationship(typeName)));
            Response okEmptyResponse = new Response().description("Successful response");
            com.yahoo.elide.core.type.Type<?> parentClass = this.lineage.peek().getType();
            RelationshipType relationshipType = SwaggerBuilder.this.dictionary.getRelationshipType(parentClass, this.name);
            if (relationshipType.isToMany()) {
                path.get(new JsonApiOperation().description("Returns the relationship identifiers for " + this.name).tag(this.getTag()).response(200, okPluralResponse));
                path.patch(new JsonApiOperation().description("Replaces the relationship " + this.name).tag(this.getTag()).response(204, okEmptyResponse).parameter((Parameter)new BodyParameter().schema((Model)new Data(new Relationship(typeName))).name("relationship")));
                path.delete(new JsonApiOperation().description("Deletes items from the relationship " + this.name).tag(this.getTag()).response(204, okEmptyResponse).parameter((Parameter)new BodyParameter().schema((Model)new Data(new Relationship(typeName))).name("relationship")));
                path.post(new JsonApiOperation().description("Adds items to the relationship " + this.name).tag(this.getTag()).response(201, okPluralResponse).parameter((Parameter)new BodyParameter().schema((Model)new Data(new Relationship(typeName))).name("relationship")));
            } else {
                path.get(new JsonApiOperation().description("Returns the relationship identifiers for " + this.name).tag(this.getTag()).response(200, okSingularResponse));
                path.patch(new JsonApiOperation().description("Replaces the relationship " + this.name).tag(this.getTag()).response(204, okEmptyResponse).parameter((Parameter)new BodyParameter().schema((Model)new com.yahoo.elide.swagger.model.Datum(new Relationship(typeName))).name("relationship")));
            }
            for (Parameter param : this.getFilterParameters()) {
                path.getGet().addParameter(param);
            }
            for (Parameter param : this.getPageParameters()) {
                path.getGet().addParameter(param);
            }
            this.decorateGlobalResponses(path);
            this.decorateGlobalParameters(path);
            return path;
        }

        public Path getCollectionPath() {
            String postDescription;
            String getDescription;
            String typeName = SwaggerBuilder.this.dictionary.getJsonAliasFor(this.type);
            Path path = new Path();
            this.lineage.stream().forEach(item -> path.addParameter(item.getPathParameter()));
            Response okSingularResponse = new Response().description("Successful response").schema((Property)new Datum(typeName, false));
            Response okPluralResponse = new Response().description("Successful response").schema((Property)new com.yahoo.elide.swagger.property.Data(typeName));
            if (this.lineage.isEmpty()) {
                getDescription = "Returns the collection of type " + typeName;
                postDescription = "Creates an item of type " + typeName;
            } else {
                getDescription = "Returns the relationship " + this.name;
                postDescription = "Creates an item of type " + typeName + " and adds it to " + this.name;
            }
            path.get(new JsonApiOperation().description(getDescription).parameter(this.getSortParameter()).parameter(this.getSparseFieldsParameter()).parameter(this.getIncludeParameter()).tag(this.getTag()).response(200, okPluralResponse));
            for (Parameter param : this.getFilterParameters()) {
                path.getGet().addParameter(param);
            }
            for (Parameter param : this.getPageParameters()) {
                path.getGet().addParameter(param);
            }
            path.post(new JsonApiOperation().description(postDescription).tag(this.getTag()).response(201, okSingularResponse).parameter((Parameter)new BodyParameter().schema((Model)new com.yahoo.elide.swagger.model.Datum(typeName)).name(typeName)));
            this.decorateGlobalResponses(path);
            this.decorateGlobalParameters(path);
            return path;
        }

        public Path getInstancePath() {
            String typeName = SwaggerBuilder.this.dictionary.getJsonAliasFor(this.type);
            Path path = new Path();
            this.getFullLineage().stream().forEach(item -> path.addParameter(item.getPathParameter()));
            Response okSingularResponse = new Response().description("Successful response").schema((Property)new Datum(typeName));
            Response okEmptyResponse = new Response().description("Successful response");
            path.get(new JsonApiOperation().description("Returns an instance of type " + typeName).tag(this.getTag()).parameter(this.getSparseFieldsParameter()).parameter(this.getIncludeParameter()).response(200, okSingularResponse));
            path.patch(new JsonApiOperation().description("Modifies an instance of type " + typeName).tag(this.getTag()).response(204, okEmptyResponse).parameter((Parameter)new BodyParameter().schema((Model)new com.yahoo.elide.swagger.model.Datum(typeName)).name(typeName)));
            path.delete(new JsonApiOperation().description("Deletes an instance of type " + typeName).tag(this.getTag()).response(204, okEmptyResponse));
            this.decorateGlobalResponses(path);
            this.decorateGlobalParameters(path);
            return path;
        }

        private Path decorateGlobalParameters(Path path) {
            SwaggerBuilder.this.globalParams.forEach(param -> path.addParameter(param));
            return path;
        }

        private Path decorateGlobalResponses(Path path) {
            SwaggerBuilder.this.globalResponses.forEach((code, response) -> {
                if (path.getGet() != null) {
                    path.getGet().response(code.intValue(), response);
                }
                if (path.getDelete() != null) {
                    path.getDelete().response(code.intValue(), response);
                }
                if (path.getPost() != null) {
                    path.getPost().response(code.intValue(), response);
                }
                if (path.getPatch() != null) {
                    path.getPatch().response(code.intValue(), response);
                }
            });
            return path;
        }

        private Parameter getSparseFieldsParameter() {
            String typeName = SwaggerBuilder.this.dictionary.getJsonAliasFor(this.type);
            List fieldNames = SwaggerBuilder.this.dictionary.getAllFields(this.type);
            return ((QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().type("array")).name("fields[" + typeName + "]")).description("Selects the set of " + typeName + " fields that should be returned in the result.")).items((Property)new StringProperty()._enum(fieldNames))).collectionFormat("csv");
        }

        private Parameter getIncludeParameter() {
            List relationshipNames = SwaggerBuilder.this.dictionary.getRelationships(this.type);
            return ((QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().type("array")).name("include")).description("Selects the set of relationships that should be expanded as a compound document in the result.")).items((Property)new StringProperty()._enum(relationshipNames))).collectionFormat("csv");
        }

        private List<Parameter> getPageParameters() {
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            params.add((Parameter)((QueryParameter)((QueryParameter)new QueryParameter().name("page[number]")).description("Number of pages to return.  Can be used with page[size]")).type("integer"));
            params.add((Parameter)((QueryParameter)((QueryParameter)new QueryParameter().name("page[size]")).description("Number of elements per page.  Can be used with page[number]")).type("integer"));
            params.add((Parameter)((QueryParameter)((QueryParameter)new QueryParameter().name("page[offset]")).description("Offset from 0 to start paginating.  Can be used with page[limit]")).type("integer"));
            params.add((Parameter)((QueryParameter)((QueryParameter)new QueryParameter().name("page[limit]")).description("Maximum number of items to return.  Can be used with page[offset]")).type("integer"));
            params.add((Parameter)((QueryParameter)((QueryParameter)new QueryParameter().name("page[totals]")).description("For requesting total pages/records be included in the response page meta data")).type("string"));
            return params;
        }

        private Parameter getSortParameter() {
            List filterAttributes = SwaggerBuilder.this.dictionary.getAttributes(this.type).stream().filter(name -> {
                com.yahoo.elide.core.type.Type attributeClass = SwaggerBuilder.this.dictionary.getType(this.type, name);
                return attributeClass.isPrimitive() || ClassType.STRING_TYPE.isAssignableFrom(attributeClass);
            }).map(name -> Arrays.asList(name, "-" + name)).flatMap(Collection::stream).collect(Collectors.toList());
            filterAttributes.add("id");
            filterAttributes.add("-id");
            return ((QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("sort")).type("array")).description("Sorts the collection on the selected attributes.  A prefix of '-' sorts descending")).items((Property)new StringProperty()._enum(filterAttributes))).collectionFormat("csv");
        }

        private List<Parameter> getFilterParameters() {
            String typeName = SwaggerBuilder.this.dictionary.getJsonAliasFor(this.type);
            List attributeNames = SwaggerBuilder.this.dictionary.getAttributes(this.type);
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            if (SwaggerBuilder.this.supportRSQLDialect) {
                params.add((Parameter)((QueryParameter)((QueryParameter)new QueryParameter().type("string")).name("filter[" + typeName + "]")).description("Filters the collection of " + typeName + " using a 'disjoint' RSQL expression"));
                if (this.lineage.isEmpty()) {
                    params.add((Parameter)((QueryParameter)((QueryParameter)new QueryParameter().type("string")).name("filter")).description("Filters the collection of " + typeName + " using a 'joined' RSQL expression"));
                }
            }
            if (SwaggerBuilder.this.supportLegacyDialect) {
                for (Operator op : SwaggerBuilder.this.filterOperators) {
                    attributeNames.forEach(name -> {
                        com.yahoo.elide.core.type.Type attributeClass = SwaggerBuilder.this.dictionary.getType(this.type, name);
                        if (attributeClass.isPrimitive() || ClassType.STRING_TYPE.isAssignableFrom(attributeClass)) {
                            params.add((Parameter)((QueryParameter)((QueryParameter)new QueryParameter().type("string")).name("filter[" + typeName + "." + name + "][" + op.getNotation() + "]")).description("Filters the collection of " + typeName + " by the attribute " + name + " using the operator " + op.getNotation()));
                        }
                    });
                }
            }
            return params;
        }

        public Stack<PathMetaData> getFullLineage() {
            Stack<PathMetaData> fullLineage = new Stack<PathMetaData>();
            fullLineage.addAll(this.lineage);
            fullLineage.add(this);
            return fullLineage;
        }

        public boolean shorterThan(PathMetaData compare) {
            return compare.getUrl().startsWith(this.url);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PathMetaData)) {
                return false;
            }
            PathMetaData that = (PathMetaData)o;
            return this.url.equals(that.getUrl());
        }

        public int hashCode() {
            return Objects.hash(this.lineage, this.name, this.type);
        }

        private boolean lineageContainsType(PathMetaData other) {
            if (this.type.equals(other.type)) {
                return true;
            }
            if (this.lineage.isEmpty()) {
                return false;
            }
            for (PathMetaData compare : this.lineage) {
                if (!compare.type.equals(other.type)) continue;
                return true;
            }
            return false;
        }

        public String getName() {
            return this.name;
        }

        public com.yahoo.elide.core.type.Type<?> getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

