/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.swagger.resources;

import com.yahoo.elide.swagger.SwaggerBuilder;
import io.swagger.models.Swagger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;

@Path(value="/doc")
@Produces(value={"application/json"})
public class DocEndpoint {
    protected Map<Pair<String, String>, String> documents = new HashMap<Pair<String, String>, String>();

    @Inject
    public DocEndpoint(@Named(value="swagger") List<SwaggerRegistration> docs) {
        docs.forEach(doc -> {
            String apiVersion = doc.document.getInfo().getVersion();
            apiVersion = apiVersion == null ? "" : apiVersion;
            String apiPath = doc.path;
            this.documents.put((Pair<String, String>)Pair.of((Object)apiVersion, (Object)apiPath), SwaggerBuilder.getDocument(doc.document));
        });
    }

    @GET
    @Path(value="/")
    public Response list(@HeaderParam(value="ApiVersion") String apiVersion) {
        String safeApiVersion = apiVersion == null ? "" : apiVersion;
        String body = this.documents.keySet().stream().filter(key -> ((String)key.getLeft()).equals(safeApiVersion)).map(Pair::getRight).map(key -> "\"" + key + "\"").collect(Collectors.joining(",", "[", "]"));
        return Response.ok((Object)body).build();
    }

    @GET
    @Path(value="/{name}")
    public Response get(@HeaderParam(value="ApiVersion") String apiVersion, @PathParam(value="name") String name) {
        String safeApiVersion = apiVersion == null ? "" : apiVersion;
        Pair lookupKey = Pair.of((Object)safeApiVersion, (Object)name);
        if (this.documents.containsKey(lookupKey)) {
            return Response.ok((Object)this.documents.get(lookupKey)).build();
        }
        return Response.status((int)404).entity((Object)("Unknown document: " + name)).build();
    }

    public static class SwaggerRegistration {
        private String path;
        private Swagger document;

        public String getPath() {
            return this.path;
        }

        public Swagger getDocument() {
            return this.document;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setDocument(Swagger document) {
            this.document = document;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SwaggerRegistration)) {
                return false;
            }
            SwaggerRegistration other = (SwaggerRegistration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Swagger this$document = this.getDocument();
            Swagger other$document = other.getDocument();
            return !(this$document == null ? other$document != null : !this$document.equals(other$document));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SwaggerRegistration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Swagger $document = this.getDocument();
            result = result * 59 + ($document == null ? 43 : $document.hashCode());
            return result;
        }

        public String toString() {
            return "DocEndpoint.SwaggerRegistration(path=" + this.getPath() + ", document=" + this.getDocument() + ")";
        }

        public SwaggerRegistration(String path, Swagger document) {
            this.path = path;
            this.document = document;
        }
    }
}

