/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.test.graphql.elements;

import com.yahoo.elide.test.graphql.elements.Arguments;
import com.yahoo.elide.test.graphql.elements.Selection;
import com.yahoo.elide.test.graphql.elements.SelectionSet;
import java.io.Serializable;
import lombok.NonNull;

public class Field
extends Selection {
    private static final long serialVersionUID = -5906705888838083150L;
    private final String alias;
    @NonNull
    private final String name;
    @NonNull
    private final Arguments arguments;
    private final Serializable selectionSet;

    public static Field scalarField(String name) {
        return new Field(null, name, Arguments.emptyArgument(), null);
    }

    public static String quoteValue(String value) {
        return String.format("\"%s\"", value.replace("\"", "\\\""));
    }

    @Override
    public String toGraphQLSpec() {
        return String.format("%s%s%s%s", this.getAlias() == null ? "" : this.getAlias() + ": ", this.getName(), this.argument(), this.selection());
    }

    @Override
    public String toResponse() {
        if (this.selectionSet instanceof String || this.selectionSet instanceof Number) {
            return String.format("\"%s\":%s", this.getName(), this.getSelectionSet().toString().equals("") ? "{\"edges\":[]}" : this.getSelectionSet().toString());
        }
        if (this.getSelectionSet() == null) {
            return String.format("\"%s\":%s", this.getName(), null);
        }
        return String.format("\"%s\":%s", this.getName(), ((SelectionSet)this.getSelectionSet()).toResponse());
    }

    private String argument() {
        return this.getArguments().noArgument() ? "" : this.getArguments().toGraphQLSpec();
    }

    private String selection() {
        return this.getSelectionSet() == null ? "" : " " + ((SelectionSet)this.getSelectionSet()).toGraphQLSpec();
    }

    public Field(String alias, @NonNull String name, @NonNull Arguments arguments, Serializable selectionSet) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        this.alias = alias;
        this.name = name;
        this.arguments = arguments;
        this.selectionSet = selectionSet;
    }

    private String getAlias() {
        return this.alias;
    }

    @NonNull
    private String getName() {
        return this.name;
    }

    @NonNull
    private Arguments getArguments() {
        return this.arguments;
    }

    private Serializable getSelectionSet() {
        return this.selectionSet;
    }
}

