/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.log4j;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MeterMetric;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class InstrumentedAppender
implements Appender {
    private static final MeterMetric ALL_METER = Metrics.newMeter(InstrumentedAppender.class, (String)"all", (String)"statements", (TimeUnit)TimeUnit.SECONDS);
    private static final MeterMetric TRACE_METER = Metrics.newMeter(InstrumentedAppender.class, (String)"trace", (String)"statements", (TimeUnit)TimeUnit.SECONDS);
    private static final MeterMetric DEBUG_METER = Metrics.newMeter(InstrumentedAppender.class, (String)"debug", (String)"statements", (TimeUnit)TimeUnit.SECONDS);
    private static final MeterMetric INFO_METER = Metrics.newMeter(InstrumentedAppender.class, (String)"info", (String)"statements", (TimeUnit)TimeUnit.SECONDS);
    private static final MeterMetric WARN_METER = Metrics.newMeter(InstrumentedAppender.class, (String)"warn", (String)"statements", (TimeUnit)TimeUnit.SECONDS);
    private static final MeterMetric ERROR_METER = Metrics.newMeter(InstrumentedAppender.class, (String)"error", (String)"statements", (TimeUnit)TimeUnit.SECONDS);
    private static final MeterMetric FATAL_METER = Metrics.newMeter(InstrumentedAppender.class, (String)"fatal", (String)"statements", (TimeUnit)TimeUnit.SECONDS);
    private final Appender underlying;

    public InstrumentedAppender(Appender underlying) {
        this.underlying = underlying;
    }

    public void addFilter(Filter newFilter) {
        this.underlying.addFilter(newFilter);
    }

    public void clearFilters() {
        this.underlying.clearFilters();
    }

    public void close() {
        this.underlying.close();
    }

    public void doAppend(LoggingEvent event) {
        ALL_METER.mark();
        if (event.getLevel() == Level.TRACE) {
            TRACE_METER.mark();
        } else if (event.getLevel() == Level.DEBUG) {
            DEBUG_METER.mark();
        } else if (event.getLevel() == Level.INFO) {
            INFO_METER.mark();
        } else if (event.getLevel() == Level.WARN) {
            WARN_METER.mark();
        } else if (event.getLevel() == Level.ERROR) {
            ERROR_METER.mark();
        } else if (event.getLevel() == Level.FATAL) {
            FATAL_METER.mark();
        }
        this.underlying.doAppend(event);
    }

    public ErrorHandler getErrorHandler() {
        return this.underlying.getErrorHandler();
    }

    public Filter getFilter() {
        return this.underlying.getFilter();
    }

    public Layout getLayout() {
        return this.underlying.getLayout();
    }

    public String getName() {
        return this.underlying.getName();
    }

    public boolean requiresLayout() {
        return this.underlying.requiresLayout();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.underlying.setErrorHandler(errorHandler);
    }

    public void setLayout(Layout layout) {
        this.underlying.setLayout(layout);
    }

    public void setName(String name) {
        this.underlying.setName(name);
    }
}

