/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.reporting;

import com.yammer.metrics.HealthChecks;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.HealthCheck;
import com.yammer.metrics.core.HealthCheckRegistry;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.stats.Snapshot;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsServlet
extends HttpServlet
implements MetricProcessor<Context> {
    private static final long serialVersionUID = 1363903248255082791L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsServlet.class);
    public static final String ATTR_NAME_METRICS_REGISTRY = MetricsServlet.class.getSimpleName() + ":" + MetricsRegistry.class.getSimpleName();
    public static final String ATTR_NAME_HEALTHCHECK_REGISTRY = MetricsServlet.class.getSimpleName() + ":" + HealthCheckRegistry.class.getSimpleName();
    public static final String ATTR_NAME_VM_REGISTRY = MetricsServlet.class.getSimpleName() + ":" + VirtualMachineMetrics.class.getSimpleName();
    private static final String TEMPLATE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n        \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n  <title>Metrics</title>\n</head>\n<body>\n  <h1>Operational Menu</h1>\n  <ul>\n    <li><a href=\"{0}{1}?pretty=true\">Metrics</a></li>\n    <li><a href=\"{2}{3}\">Ping</a></li>\n    <li><a href=\"{4}{5}\">Threads</a></li>\n    <li><a href=\"{6}{7}\">Healthcheck</a></li>\n  </ul>\n</body>\n</html>";
    public static final String HEALTHCHECK_URI = "/healthcheck";
    public static final String METRICS_URI = "/metrics";
    public static final String PING_URI = "/ping";
    public static final String THREADS_URI = "/threads";
    private MetricsRegistry metricsRegistry;
    private HealthCheckRegistry healthCheckRegistry;
    private VirtualMachineMetrics vm;
    private JsonFactory factory;
    private String metricsUri;
    private String pingUri;
    private String threadsUri;
    private String healthcheckUri;
    private String contextPath;
    private boolean showJvmMetrics;

    public MetricsServlet() {
        this(new JsonFactory((ObjectCodec)new ObjectMapper()), HEALTHCHECK_URI, METRICS_URI, PING_URI, THREADS_URI, true);
    }

    public MetricsServlet(boolean showJvmMetrics) {
        this(new JsonFactory((ObjectCodec)new ObjectMapper()), HEALTHCHECK_URI, METRICS_URI, PING_URI, THREADS_URI, showJvmMetrics);
    }

    public MetricsServlet(JsonFactory factory) {
        this(factory, HEALTHCHECK_URI, METRICS_URI, PING_URI, THREADS_URI);
    }

    public MetricsServlet(JsonFactory factory, boolean showJvmMetrics) {
        this(factory, HEALTHCHECK_URI, METRICS_URI, PING_URI, THREADS_URI, showJvmMetrics);
    }

    public MetricsServlet(String healthcheckUri, String metricsUri, String pingUri, String threadsUri) {
        this(new JsonFactory((ObjectCodec)new ObjectMapper()), healthcheckUri, metricsUri, pingUri, threadsUri);
    }

    public MetricsServlet(JsonFactory factory, String healthcheckUri, String metricsUri, String pingUri, String threadsUri) {
        this(factory, healthcheckUri, metricsUri, pingUri, threadsUri, true);
    }

    public MetricsServlet(JsonFactory factory, String healthcheckUri, String metricsUri, String pingUri, String threadsUri, boolean showJvmMetrics) {
        this(Metrics.defaultRegistry(), HealthChecks.defaultRegistry(), factory, healthcheckUri, metricsUri, pingUri, threadsUri, showJvmMetrics);
    }

    public MetricsServlet(MetricsRegistry metricsRegistry, HealthCheckRegistry healthCheckRegistry, String healthcheckUri, String metricsUri, String pingUri, String threadsUri, boolean showJvmMetrics) {
        this(metricsRegistry, healthCheckRegistry, new JsonFactory((ObjectCodec)new ObjectMapper()), healthcheckUri, metricsUri, pingUri, threadsUri, showJvmMetrics);
    }

    public MetricsServlet(MetricsRegistry metricsRegistry, HealthCheckRegistry healthCheckRegistry, JsonFactory factory, String healthcheckUri, String metricsUri, String pingUri, String threadsUri, boolean showJvmMetrics) {
        this(metricsRegistry, healthCheckRegistry, VirtualMachineMetrics.getInstance(), factory, healthcheckUri, metricsUri, pingUri, threadsUri, showJvmMetrics);
    }

    public MetricsServlet(MetricsRegistry metricsRegistry, HealthCheckRegistry healthCheckRegistry, VirtualMachineMetrics vm, JsonFactory factory, String healthcheckUri, String metricsUri, String pingUri, String threadsUri, boolean showJvmMetrics) {
        this.metricsRegistry = metricsRegistry;
        this.healthCheckRegistry = healthCheckRegistry;
        this.vm = vm;
        this.factory = factory;
        this.metricsUri = metricsUri;
        this.pingUri = pingUri;
        this.threadsUri = threadsUri;
        this.healthcheckUri = healthcheckUri;
        this.showJvmMetrics = showJvmMetrics;
    }

    public void init(ServletConfig config) throws ServletException {
        Object factory;
        super.init(config);
        ServletContext context = config.getServletContext();
        this.contextPath = context.getContextPath();
        this.metricsRegistry = MetricsServlet.putAttrIfAbsent(context, ATTR_NAME_METRICS_REGISTRY, this.metricsRegistry);
        this.healthCheckRegistry = MetricsServlet.putAttrIfAbsent(context, ATTR_NAME_HEALTHCHECK_REGISTRY, this.healthCheckRegistry);
        this.vm = MetricsServlet.putAttrIfAbsent(context, ATTR_NAME_VM_REGISTRY, this.vm);
        this.metricsUri = MetricsServlet.getParam(config.getInitParameter("metrics-uri"), this.metricsUri);
        this.pingUri = MetricsServlet.getParam(config.getInitParameter("ping-uri"), this.pingUri);
        this.threadsUri = MetricsServlet.getParam(config.getInitParameter("threads-uri"), this.threadsUri);
        this.healthcheckUri = MetricsServlet.getParam(config.getInitParameter("healthcheck-uri"), this.healthcheckUri);
        String showJvmMetricsParam = config.getInitParameter("show-jvm-metrics");
        if (showJvmMetricsParam != null) {
            this.showJvmMetrics = Boolean.parseBoolean(showJvmMetricsParam);
        }
        if ((factory = config.getServletContext().getAttribute(JsonFactory.class.getCanonicalName())) != null && factory instanceof JsonFactory) {
            this.factory = (JsonFactory)factory;
        }
    }

    private static String getParam(String initParam, String defaultValue) {
        return initParam == null ? defaultValue : initParam;
    }

    private static <T> T putAttrIfAbsent(ServletContext context, String attrName, T defaultValue) {
        Object attrValue = context.getAttribute(attrName);
        if (attrValue == null) {
            attrValue = defaultValue;
            context.setAttribute(attrName, attrValue);
        }
        return (T)attrValue;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        String uri = req.getPathInfo();
        String path = this.contextPath + req.getServletPath();
        if (uri == null || uri.equals("/")) {
            this.handleHome(path, resp);
        } else if (uri.startsWith(this.metricsUri)) {
            this.handleMetrics(req.getParameter("class"), Boolean.parseBoolean(req.getParameter("full-samples")), Boolean.parseBoolean(req.getParameter("pretty")), resp);
        } else if (uri.equals(this.pingUri)) {
            MetricsServlet.handlePing(resp);
        } else if (uri.equals(this.threadsUri)) {
            this.handleThreadDump(resp);
        } else if (uri.equals(this.healthcheckUri)) {
            this.handleHealthCheck(resp);
        } else {
            resp.sendError(404);
        }
    }

    private void handleHome(String path, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        writer.println(MessageFormat.format(TEMPLATE, path, this.metricsUri, path, this.pingUri, path, this.threadsUri, path, this.healthcheckUri));
        writer.close();
    }

    private void handleHealthCheck(HttpServletResponse resp) throws IOException {
        boolean allHealthy = true;
        SortedMap results = this.healthCheckRegistry.runHealthChecks();
        for (HealthCheck.Result result : results.values()) {
            allHealthy &= result.isHealthy();
        }
        resp.setContentType("text/plain");
        PrintWriter writer = resp.getWriter();
        if (results.isEmpty()) {
            resp.setStatus(501);
            writer.println("! No health checks registered.");
        } else {
            if (allHealthy) {
                resp.setStatus(200);
            } else {
                resp.setStatus(500);
            }
            for (Map.Entry entry : results.entrySet()) {
                Throwable error;
                HealthCheck.Result result = (HealthCheck.Result)entry.getValue();
                if (result.isHealthy()) {
                    if (result.getMessage() != null) {
                        writer.format("* %s: OK: %s\n", entry.getKey(), result.getMessage());
                        continue;
                    }
                    writer.format("* %s: OK\n", entry.getKey());
                    continue;
                }
                if (result.getMessage() != null) {
                    writer.format("! %s: ERROR\n!  %s\n", entry.getKey(), result.getMessage());
                }
                if ((error = result.getError()) == null) continue;
                writer.println();
                error.printStackTrace(writer);
                writer.println();
            }
        }
        writer.close();
    }

    private void handleThreadDump(HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setContentType("text/plain");
        ServletOutputStream output = resp.getOutputStream();
        this.vm.threadDump((OutputStream)output);
        output.close();
    }

    private static void handlePing(HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setContentType("text/plain");
        PrintWriter writer = resp.getWriter();
        writer.println("pong");
        writer.close();
    }

    private void handleMetrics(String classPrefix, boolean showFullSamples, boolean pretty, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setContentType("application/json");
        ServletOutputStream output = resp.getOutputStream();
        JsonGenerator json = this.factory.createJsonGenerator((OutputStream)output, JsonEncoding.UTF8);
        if (pretty) {
            json.useDefaultPrettyPrinter();
        }
        json.writeStartObject();
        if (this.showJvmMetrics && ("jvm".equals(classPrefix) || classPrefix == null)) {
            this.writeVmMetrics(json);
        }
        this.writeRegularMetrics(json, classPrefix, showFullSamples);
        json.writeEndObject();
        json.close();
    }

    public void writeRegularMetrics(JsonGenerator json, String classPrefix, boolean showFullSamples) throws IOException {
        for (Map.Entry entry : this.metricsRegistry.groupedMetrics().entrySet()) {
            if (classPrefix != null && !((String)entry.getKey()).startsWith(classPrefix)) continue;
            json.writeFieldName((String)entry.getKey());
            json.writeStartObject();
            for (Map.Entry subEntry : ((SortedMap)entry.getValue()).entrySet()) {
                json.writeFieldName(((MetricName)subEntry.getKey()).getName());
                try {
                    ((Metric)subEntry.getValue()).processWith((MetricProcessor)this, (MetricName)subEntry.getKey(), (Object)new Context(json, showFullSamples));
                }
                catch (Exception ignored) {}
            }
            json.writeEndObject();
        }
    }

    public void processHistogram(MetricName name, Histogram histogram, Context context) throws Exception {
        JsonGenerator json = context.json;
        json.writeStartObject();
        json.writeStringField("type", "histogram");
        json.writeNumberField("count", histogram.count());
        MetricsServlet.writeSummarizable((Summarizable)histogram, json);
        MetricsServlet.writeSampling((Sampling)histogram, json);
        if (context.showFullSamples) {
            json.writeObjectField("values", (Object)histogram.getSnapshot().getValues());
        }
        json.writeEndObject();
    }

    public void processCounter(MetricName name, Counter counter, Context context) throws Exception {
        JsonGenerator json = context.json;
        json.writeStartObject();
        json.writeStringField("type", "counter");
        json.writeNumberField("count", counter.count());
        json.writeEndObject();
    }

    public void processGauge(MetricName name, Gauge<?> gauge, Context context) throws Exception {
        JsonGenerator json = context.json;
        json.writeStartObject();
        json.writeStringField("type", "gauge");
        json.writeObjectField("value", MetricsServlet.evaluateGauge(gauge));
        json.writeEndObject();
    }

    private static Object evaluateGauge(Gauge<?> gauge) {
        try {
            return gauge.value();
        }
        catch (RuntimeException e) {
            LOGGER.warn("Error evaluating gauge", (Throwable)e);
            return "error reading gauge: " + e.getMessage();
        }
    }

    private void writeVmMetrics(JsonGenerator json) throws IOException {
        json.writeFieldName("jvm");
        json.writeStartObject();
        json.writeFieldName("vm");
        json.writeStartObject();
        json.writeStringField("name", this.vm.name());
        json.writeStringField("version", this.vm.version());
        json.writeEndObject();
        json.writeFieldName("memory");
        json.writeStartObject();
        json.writeNumberField("totalInit", this.vm.totalInit());
        json.writeNumberField("totalUsed", this.vm.totalUsed());
        json.writeNumberField("totalMax", this.vm.totalMax());
        json.writeNumberField("totalCommitted", this.vm.totalCommitted());
        json.writeNumberField("heapInit", this.vm.heapInit());
        json.writeNumberField("heapUsed", this.vm.heapUsed());
        json.writeNumberField("heapMax", this.vm.heapMax());
        json.writeNumberField("heapCommitted", this.vm.heapCommitted());
        json.writeNumberField("heap_usage", this.vm.heapUsage());
        json.writeNumberField("non_heap_usage", this.vm.nonHeapUsage());
        json.writeFieldName("memory_pool_usages");
        json.writeStartObject();
        for (Map.Entry pool : this.vm.memoryPoolUsage().entrySet()) {
            json.writeNumberField((String)pool.getKey(), ((Double)pool.getValue()).doubleValue());
        }
        json.writeEndObject();
        json.writeEndObject();
        json.writeNumberField("daemon_thread_count", this.vm.daemonThreadCount());
        json.writeNumberField("thread_count", this.vm.threadCount());
        json.writeNumberField("current_time", System.currentTimeMillis());
        json.writeNumberField("uptime", this.vm.uptime());
        json.writeNumberField("fd_usage", this.vm.fileDescriptorUsage());
        json.writeFieldName("thread-states");
        json.writeStartObject();
        for (Map.Entry entry : this.vm.threadStatePercentages().entrySet()) {
            json.writeNumberField(((Thread.State)((Object)entry.getKey())).toString().toLowerCase(), ((Double)entry.getValue()).doubleValue());
        }
        json.writeEndObject();
        json.writeFieldName("garbage-collectors");
        json.writeStartObject();
        for (Map.Entry entry : this.vm.garbageCollectors().entrySet()) {
            json.writeFieldName((String)entry.getKey());
            json.writeStartObject();
            VirtualMachineMetrics.GarbageCollectorStats gc = (VirtualMachineMetrics.GarbageCollectorStats)entry.getValue();
            json.writeNumberField("runs", gc.getRuns());
            json.writeNumberField("time", gc.getTime(TimeUnit.MILLISECONDS));
            json.writeEndObject();
        }
        json.writeEndObject();
        json.writeEndObject();
    }

    public void processMeter(MetricName name, Metered meter, Context context) throws Exception {
        JsonGenerator json = context.json;
        json.writeStartObject();
        json.writeStringField("type", "meter");
        json.writeStringField("event_type", meter.eventType());
        MetricsServlet.writeMeteredFields(meter, json);
        json.writeEndObject();
    }

    public void processTimer(MetricName name, Timer timer, Context context) throws Exception {
        JsonGenerator json = context.json;
        json.writeStartObject();
        json.writeStringField("type", "timer");
        json.writeFieldName("duration");
        json.writeStartObject();
        json.writeStringField("unit", timer.durationUnit().toString().toLowerCase());
        MetricsServlet.writeSummarizable((Summarizable)timer, json);
        MetricsServlet.writeSampling((Sampling)timer, json);
        if (context.showFullSamples) {
            json.writeObjectField("values", (Object)timer.getSnapshot().getValues());
        }
        json.writeEndObject();
        json.writeFieldName("rate");
        json.writeStartObject();
        MetricsServlet.writeMeteredFields((Metered)timer, json);
        json.writeEndObject();
        json.writeEndObject();
    }

    private static void writeSummarizable(Summarizable metric, JsonGenerator json) throws IOException {
        json.writeNumberField("min", metric.min());
        json.writeNumberField("max", metric.max());
        json.writeNumberField("mean", metric.mean());
        json.writeNumberField("std_dev", metric.stdDev());
    }

    private static void writeSampling(Sampling metric, JsonGenerator json) throws IOException {
        Snapshot snapshot = metric.getSnapshot();
        json.writeNumberField("median", snapshot.getMedian());
        json.writeNumberField("p75", snapshot.get75thPercentile());
        json.writeNumberField("p95", snapshot.get95thPercentile());
        json.writeNumberField("p98", snapshot.get98thPercentile());
        json.writeNumberField("p99", snapshot.get99thPercentile());
        json.writeNumberField("p999", snapshot.get999thPercentile());
    }

    private static void writeMeteredFields(Metered metered, JsonGenerator json) throws IOException {
        json.writeStringField("unit", metered.rateUnit().toString().toLowerCase());
        json.writeNumberField("count", metered.count());
        json.writeNumberField("mean", metered.meanRate());
        json.writeNumberField("m1", metered.oneMinuteRate());
        json.writeNumberField("m5", metered.fiveMinuteRate());
        json.writeNumberField("m15", metered.fifteenMinuteRate());
    }

    static final class Context {
        public final boolean showFullSamples;
        public final JsonGenerator json;

        Context(JsonGenerator json, boolean showFullSamples) {
            this.json = json;
            this.showFullSamples = showFullSamples;
        }
    }
}

