/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.data.AuthenticatorAssertionExtensionOutputs;
import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.AuthenticatorAttachment;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class AssertionResult {
    private final boolean success;
    @JsonProperty
    private final PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> credentialResponse;
    private final RegisteredCredential credential;
    @NonNull
    private final String username;
    private final boolean signatureCounterValid;

    @JsonCreator
    AssertionResult(@JsonProperty(value="success") boolean success, @JsonProperty(value="credentialResponse") @NonNull PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> credentialResponse, @JsonProperty(value="credential") @NonNull RegisteredCredential credential, @JsonProperty(value="username") @NonNull String username, @JsonProperty(value="signatureCounterValid") boolean signatureCounterValid) {
        if (credentialResponse == null) {
            throw new NullPointerException("credentialResponse is marked non-null but is null");
        }
        if (credential == null) {
            throw new NullPointerException("credential is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.success = success;
        this.credentialResponse = credentialResponse;
        this.credential = credential;
        this.username = username;
        this.signatureCounterValid = signatureCounterValid;
    }

    @Deprecated
    @JsonIgnore
    public ByteArray getCredentialId() {
        return this.credential.getCredentialId();
    }

    @Deprecated
    @JsonIgnore
    public ByteArray getUserHandle() {
        return this.credential.getUserHandle();
    }

    @JsonIgnore
    public boolean isUserVerified() {
        return this.credentialResponse.getResponse().getParsedAuthenticatorData().getFlags().UV;
    }

    @Deprecated
    @JsonIgnore
    public boolean isBackupEligible() {
        return this.credentialResponse.getResponse().getParsedAuthenticatorData().getFlags().BE;
    }

    @Deprecated
    @JsonIgnore
    public boolean isBackedUp() {
        return this.credentialResponse.getResponse().getParsedAuthenticatorData().getFlags().BS;
    }

    @Deprecated
    @JsonIgnore
    public Optional<AuthenticatorAttachment> getAuthenticatorAttachment() {
        return this.credentialResponse.getAuthenticatorAttachment();
    }

    @JsonIgnore
    public long getSignatureCount() {
        return this.credentialResponse.getResponse().getParsedAuthenticatorData().getSignatureCounter();
    }

    @JsonIgnore
    public Optional<ClientAssertionExtensionOutputs> getClientExtensionOutputs() {
        return Optional.of(this.credentialResponse.getClientExtensionResults()).filter(ceo -> !ceo.getExtensionIds().isEmpty());
    }

    @JsonIgnore
    public Optional<AuthenticatorAssertionExtensionOutputs> getAuthenticatorExtensionOutputs() {
        return AuthenticatorAssertionExtensionOutputs.fromAuthenticatorData(this.credentialResponse.getResponse().getParsedAuthenticatorData());
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public RegisteredCredential getCredential() {
        return this.credential;
    }

    @NonNull
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public boolean isSignatureCounterValid() {
        return this.signatureCounterValid;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssertionResult)) {
            return false;
        }
        AssertionResult other = (AssertionResult)o;
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.isSignatureCounterValid() != other.isSignatureCounterValid()) {
            return false;
        }
        PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> this$credentialResponse = this.credentialResponse;
        PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> other$credentialResponse = other.credentialResponse;
        if (this$credentialResponse == null ? other$credentialResponse != null : !((Object)this$credentialResponse).equals(other$credentialResponse)) {
            return false;
        }
        RegisteredCredential this$credential = this.getCredential();
        RegisteredCredential other$credential = other.getCredential();
        if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !this$username.equals(other$username));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + (this.isSignatureCounterValid() ? 79 : 97);
        PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> $credentialResponse = this.credentialResponse;
        result = result * 59 + ($credentialResponse == null ? 43 : ((Object)$credentialResponse).hashCode());
        RegisteredCredential $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssertionResult(success=" + this.isSuccess() + ", credentialResponse=" + this.credentialResponse + ", credential=" + this.getCredential() + ", username=" + this.getUsername() + ", signatureCounterValid=" + this.isSignatureCounterValid() + ")";
    }
}

