/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.ClientExtensionOutputs;
import com.yubico.webauthn.data.Extensions;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ClientAssertionExtensionOutputs
implements ClientExtensionOutputs {
    private final Boolean appid;
    private final Extensions.LargeBlob.LargeBlobAuthenticationOutput largeBlob;
    private final Extensions.Prf.PrfAuthenticationOutput prf;

    @JsonCreator
    private ClientAssertionExtensionOutputs(@JsonProperty(value="appid") Boolean appid, @JsonProperty(value="largeBlob") Extensions.LargeBlob.LargeBlobAuthenticationOutput largeBlob, @JsonProperty(value="prf") Extensions.Prf.PrfAuthenticationOutput prf) {
        this.appid = appid;
        this.largeBlob = largeBlob;
        this.prf = prf;
    }

    @Override
    public Set<String> getExtensionIds() {
        HashSet<String> ids = new HashSet<String>();
        if (this.appid != null) {
            ids.add("appid");
        }
        if (this.largeBlob != null) {
            ids.add("largeBlob");
        }
        if (this.prf != null) {
            ids.add("prf");
        }
        return ids;
    }

    public Optional<Boolean> getAppid() {
        return Optional.ofNullable(this.appid);
    }

    public Optional<Extensions.LargeBlob.LargeBlobAuthenticationOutput> getLargeBlob() {
        return Optional.ofNullable(this.largeBlob);
    }

    public Optional<Extensions.Prf.PrfAuthenticationOutput> getPrf() {
        return Optional.ofNullable(this.prf);
    }

    @Generated
    public static ClientAssertionExtensionOutputsBuilder builder() {
        return new ClientAssertionExtensionOutputsBuilder();
    }

    @Generated
    public ClientAssertionExtensionOutputsBuilder toBuilder() {
        return new ClientAssertionExtensionOutputsBuilder().appid(this.appid).largeBlob(this.largeBlob).prf(this.prf);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientAssertionExtensionOutputs)) {
            return false;
        }
        ClientAssertionExtensionOutputs other = (ClientAssertionExtensionOutputs)o;
        Optional<Boolean> this$appid = this.getAppid();
        Optional<Boolean> other$appid = other.getAppid();
        if (this$appid == null ? other$appid != null : !((Object)this$appid).equals(other$appid)) {
            return false;
        }
        Optional<Extensions.LargeBlob.LargeBlobAuthenticationOutput> this$largeBlob = this.getLargeBlob();
        Optional<Extensions.LargeBlob.LargeBlobAuthenticationOutput> other$largeBlob = other.getLargeBlob();
        if (this$largeBlob == null ? other$largeBlob != null : !((Object)this$largeBlob).equals(other$largeBlob)) {
            return false;
        }
        Optional<Extensions.Prf.PrfAuthenticationOutput> this$prf = this.getPrf();
        Optional<Extensions.Prf.PrfAuthenticationOutput> other$prf = other.getPrf();
        if (this$prf == null ? other$prf != null : !((Object)this$prf).equals(other$prf)) {
            return false;
        }
        Set<String> this$$getExtensionIds = this.getExtensionIds();
        Set<String> other$$getExtensionIds = other.getExtensionIds();
        return !(this$$getExtensionIds == null ? other$$getExtensionIds != null : !((Object)this$$getExtensionIds).equals(other$$getExtensionIds));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Boolean> $appid = this.getAppid();
        result = result * 59 + ($appid == null ? 43 : ((Object)$appid).hashCode());
        Optional<Extensions.LargeBlob.LargeBlobAuthenticationOutput> $largeBlob = this.getLargeBlob();
        result = result * 59 + ($largeBlob == null ? 43 : ((Object)$largeBlob).hashCode());
        Optional<Extensions.Prf.PrfAuthenticationOutput> $prf = this.getPrf();
        result = result * 59 + ($prf == null ? 43 : ((Object)$prf).hashCode());
        Set<String> $$getExtensionIds = this.getExtensionIds();
        result = result * 59 + ($$getExtensionIds == null ? 43 : ((Object)$$getExtensionIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientAssertionExtensionOutputs(appid=" + this.getAppid() + ", largeBlob=" + this.getLargeBlob() + ", prf=" + this.getPrf() + ")";
    }

    public static class ClientAssertionExtensionOutputsBuilder {
        @Generated
        private Boolean appid;
        @Generated
        private Extensions.LargeBlob.LargeBlobAuthenticationOutput largeBlob;
        @Generated
        private Extensions.Prf.PrfAuthenticationOutput prf;

        public ClientAssertionExtensionOutputsBuilder appid(@NonNull Optional<Boolean> appid) {
            if (appid == null) {
                throw new NullPointerException("appid is marked non-null but is null");
            }
            this.appid = appid.orElse(null);
            return this;
        }

        private ClientAssertionExtensionOutputsBuilder appid(Boolean appid) {
            return this.appid(Optional.ofNullable(appid));
        }

        public ClientAssertionExtensionOutputsBuilder appid(boolean appid) {
            return this.appid(Optional.of(appid));
        }

        @Generated
        ClientAssertionExtensionOutputsBuilder() {
        }

        @Generated
        public ClientAssertionExtensionOutputsBuilder largeBlob(Extensions.LargeBlob.LargeBlobAuthenticationOutput largeBlob) {
            this.largeBlob = largeBlob;
            return this;
        }

        @Generated
        public ClientAssertionExtensionOutputsBuilder prf(Extensions.Prf.PrfAuthenticationOutput prf) {
            this.prf = prf;
            return this;
        }

        @Generated
        public ClientAssertionExtensionOutputs build() {
            return new ClientAssertionExtensionOutputs(this.appid, this.largeBlob, this.prf);
        }

        @Generated
        public String toString() {
            return "ClientAssertionExtensionOutputs.ClientAssertionExtensionOutputsBuilder(appid=" + this.appid + ", largeBlob=" + this.largeBlob + ", prf=" + this.prf + ")";
        }
    }
}

