/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.javassist;

import com.zaxxer.hikari.javassist.HikariInject;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashSet;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HikariClassTransformer
implements ClassFileTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariClassTransformer.class);
    private static Instrumentation ourInstrumentation;
    private static HikariClassTransformer transformer;
    private static ClassPool classPool;
    private String sniffPackage;
    private volatile boolean agentFailed;

    private HikariClassTransformer(String sniffPackage) {
        this.sniffPackage = sniffPackage;
        transformer = this;
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        ourInstrumentation = instrumentation;
        ClassPool defaultPool = ClassPool.getDefault();
        classPool = new ClassPool(defaultPool);
        classPool.importPackage("java.sql");
        HikariClassTransformer.classPool.childFirstLookup = true;
        ourInstrumentation.addTransformer(new HikariClassTransformer(agentArgs), false);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!className.startsWith(this.sniffPackage)) {
            return classfileBuffer;
        }
        try {
            ClassFile classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(classfileBuffer)));
            for (String iface : classFile.getInterfaces()) {
                if (!iface.startsWith("java.sql")) continue;
                if (iface.equals("java.sql.Connection")) {
                    return this.transformConnection(classFile);
                }
                if (iface.equals("java.sql.PreparedStatement")) {
                    return this.transformClass(classFile, "com.zaxxer.hikari.proxy.PreparedStatementProxy", "com.zaxxer.hikari.proxy.IHikariStatementProxy");
                }
                if (iface.equals("java.sql.CallableStatement")) {
                    return this.transformClass(classFile, "com.zaxxer.hikari.proxy.CallableStatementProxy", "com.zaxxer.hikari.proxy.IHikariStatementProxy");
                }
                if (iface.equals("java.sql.Statement")) {
                    return this.transformClass(classFile, "com.zaxxer.hikari.proxy.StatementProxy", "com.zaxxer.hikari.proxy.IHikariStatementProxy");
                }
                if (!iface.equals("java.sql.ResultSet")) continue;
                return this.transformClass(classFile, "com.zaxxer.hikari.proxy.ResultSetProxy", "com.zaxxer.hikari.proxy.IHikariResultSetProxy");
            }
            return classfileBuffer;
        }
        catch (Exception e) {
            this.agentFailed = true;
            LOGGER.error("Error transforming class {}", (Object)className, (Object)e);
            return classfileBuffer;
        }
    }

    public boolean isAgentFailed() {
        return this.agentFailed;
    }

    private byte[] transformConnection(ClassFile classFile) throws Exception {
        String className = classFile.getName();
        CtClass target = classPool.getCtClass(className);
        CtClass intf = classPool.get("com.zaxxer.hikari.proxy.IHikariConnectionProxy");
        target.addInterface(intf);
        LOGGER.debug("Added interface {} to {}", (Object)intf.getName(), (Object)className);
        CtClass proxy = classPool.get("com.zaxxer.hikari.proxy.ConnectionProxy");
        this.copyFields(proxy, target);
        this.copyMethods(proxy, target, classFile);
        this.mergeClassInitializers(proxy, target, classFile);
        this.specialConnectionInjectCloseCheck(target);
        this.injectTryCatch(target);
        for (CtConstructor constructor : target.getConstructors()) {
            constructor.insertAfter("__init();");
        }
        return target.toBytecode();
    }

    private byte[] transformClass(ClassFile classFile, String proxyClassName, String intfName) throws Exception {
        String className = classFile.getName();
        CtClass target = classPool.getCtClass(className);
        CtClass intf = classPool.get(intfName);
        target.addInterface(intf);
        LOGGER.debug("Added interface {} to {}", (Object)intf.getName(), (Object)className);
        CtClass proxy = classPool.get(proxyClassName);
        this.copyFields(proxy, target);
        this.copyMethods(proxy, target, classFile);
        this.mergeClassInitializers(proxy, target, classFile);
        this.injectTryCatch(target);
        return target.toBytecode();
    }

    private void copyFields(CtClass srcClass, CtClass targetClass) throws Exception {
        HashSet<CtField> srcFields = new HashSet<CtField>();
        srcFields.addAll(Arrays.asList(srcClass.getDeclaredFields()));
        srcFields.addAll(Arrays.asList(srcClass.getFields()));
        for (CtField field : srcFields) {
            if (field.getAnnotation(HikariInject.class) == null) {
                LOGGER.debug("Skipped field {}", (Object)field.getName());
                continue;
            }
            CtField copy = new CtField(field.getType(), field.getName(), targetClass);
            copy.setModifiers(field.getModifiers());
            targetClass.addField(copy);
            LOGGER.debug("Copied field {}.{} to {}", new Object[]{srcClass.getSimpleName(), field.getName(), targetClass.getSimpleName()});
        }
    }

    private void copyMethods(CtClass srcClass, CtClass targetClass, ClassFile targetClassFile) throws Exception {
        CtMethod[] destMethods = targetClass.getMethods();
        ConstPool constPool = targetClassFile.getConstPool();
        for (CtMethod method : srcClass.getDeclaredMethods()) {
            if (method.getAnnotation(HikariInject.class) == null) {
                LOGGER.debug("Skipped method {}", (Object)method.getName());
                continue;
            }
            if (targetClassFile.getMethod(method.getName()) != null) {
                String signature = method.getSignature();
                for (CtMethod destMethod : destMethods) {
                    if (!destMethod.getName().equals(method.getName()) || !destMethod.getSignature().equals(signature)) continue;
                    LOGGER.debug("Rename method {}.{} to __{}", new Object[]{targetClass.getSimpleName(), destMethod.getName(), destMethod.getName()});
                    destMethod.setName("__" + destMethod.getName());
                    break;
                }
            }
            CtMethod copy = CtNewMethod.copy((CtMethod)method, (CtClass)targetClass, null);
            AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            Annotation annotation = new Annotation("com.zaxxer.hikari.javassist.HikariInject", constPool);
            attr.setAnnotation(annotation);
            copy.getMethodInfo().addAttribute((AttributeInfo)attr);
            targetClass.addMethod(copy);
            LOGGER.debug("Copied method {}.{} to {}", new Object[]{srcClass.getSimpleName(), method.getName(), targetClass.getSimpleName()});
        }
    }

    private void mergeClassInitializers(CtClass srcClass, CtClass targetClass, ClassFile targetClassFile) throws Exception {
        CtConstructor srcInitializer = srcClass.getClassInitializer();
        if (srcInitializer == null) {
            return;
        }
        CtConstructor destInitializer = targetClass.getClassInitializer();
        if (destInitializer == null && srcInitializer != null) {
            CtConstructor copy = CtNewConstructor.copy((CtConstructor)srcInitializer, (CtClass)targetClass, null);
            targetClass.addConstructor(copy);
            CtMethod __static = CtNewMethod.make((int)8, (CtClass)CtClass.voidType, (String)"__static", null, null, (String)"{}", (CtClass)targetClass);
            targetClass.addMethod(__static);
            LOGGER.debug("Copied static initializer of {} to {}", (Object)srcClass.getSimpleName(), (Object)targetClass.getSimpleName());
        } else {
            CtMethod method = destInitializer.toMethod("__static", targetClass);
            targetClass.addMethod(method);
            targetClass.removeConstructor(destInitializer);
            LOGGER.debug("Move static initializer of {}", (Object)targetClass.getSimpleName());
            CtConstructor copy = CtNewConstructor.copy((CtConstructor)srcInitializer, (CtClass)targetClass, null);
            targetClass.addConstructor(copy);
            LOGGER.debug("Copied static initializer of {} to {}", (Object)srcClass.getSimpleName(), (Object)targetClass.getSimpleName());
        }
    }

    private void injectTryCatch(CtClass targetClass) throws Exception {
        block0: for (CtMethod method : targetClass.getDeclaredMethods()) {
            if ((method.getModifiers() & 1) != 1 || method.getAnnotation(HikariInject.class) != null || method.getMethodInfo().getCodeAttribute() == null) continue;
            for (CtClass exception : method.getExceptionTypes()) {
                if (!"java.sql.SQLException".equals(exception.getName())) continue;
                LOGGER.debug("Injecting try..catch into {}{}", (Object)method.getName(), (Object)method.getSignature());
                method.addCatch("throw checkException($e);", exception);
                continue block0;
            }
        }
    }

    private void specialConnectionInjectCloseCheck(CtClass targetClass) throws Exception {
        block0: for (CtMethod method : targetClass.getMethods()) {
            if ((method.getModifiers() & 1) != 1 || method.getAnnotation(HikariInject.class) != null || method.getMethodInfo().getCodeAttribute() == null) continue;
            for (CtClass exception : method.getExceptionTypes()) {
                if (!"java.sql.SQLException".equals(exception.getName())) continue;
                method.insertBefore("if (_isClosed) { throw new java.sql.SQLException(\"Connection is closed\"); }");
                continue block0;
            }
        }
    }

    static void unregisterInstrumenation() {
        ourInstrumentation.removeTransformer(transformer);
    }
}

