/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.javassist;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.zaxxer.hikari.javassist.HikariClassTransformer;
import com.zaxxer.hikari.util.ClassLoaderUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.bytecode.ClassFile;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariInstrumentationAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariInstrumentationAgent.class);
    private static final HashMap<String, Boolean> completionMap = new HashMap();
    private DataSource dataSource;
    private String sniffPackage;

    public HikariInstrumentationAgent(DataSource dataSource) {
        this.dataSource = dataSource;
        this.sniffPackage = this.getDataSourcePackage(dataSource);
    }

    public boolean loadTransformerAgent() {
        String jarPath = this.getSelfJarPath();
        if (jarPath == null) {
            LOGGER.warn("Cannot find the HikariCP jar file through introspection.");
            return false;
        }
        try {
            this.registerInstrumentation(jarPath);
            LOGGER.info("Successfully loaded instrumentation agent.  Scanning classes...");
        }
        catch (Exception e) {
            LOGGER.warn("Instrumentation agent could not be loaded.  Please report at http://github.com/brettwooldridge/HikariCP.", (Throwable)e);
            return false;
        }
        try {
            boolean success = this.searchInstrumentable(this.dataSource);
            completionMap.entrySet();
            if (!success) {
                LOGGER.warn("Unable to find and instrument necessary classes.  Please report at http://github.com/brettwooldridge/HikariCP.");
                LOGGER.info("Using delegation instead of instrumentation");
            } else {
                LOGGER.info("Successfully instrumented required JDBC classes.");
            }
            return success;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean searchInstrumentable(DataSource dataSource) throws Exception {
        String searchPath = this.getSearchPath(dataSource);
        if (searchPath == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        try {
            if (searchPath.endsWith(".jar")) {
                boolean bl = this.searchInstrumentableJar(searchPath);
                return bl;
            }
            String dsSubPath = dataSource.getClass().getPackage().getName().replace('.', '/');
            String classRoot = searchPath.replace(dsSubPath, "");
            searchPath = searchPath.substring(0, searchPath.lastIndexOf(47));
            boolean bl = this.seachInstrumentableDirectory(classRoot, searchPath);
            return bl;
        }
        finally {
            LOGGER.info("Instrumentation completed in {}ms.", (Object)(System.currentTimeMillis() - start));
        }
    }

    private boolean searchInstrumentableJar(String searchPath) throws IOException, ClassNotFoundException {
        File jarPath = new File(URI.create(searchPath));
        if (!jarPath.isFile()) {
            return false;
        }
        JarFile jarFile = new JarFile(jarPath, false, 1);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String entryName;
            JarEntry jarEntry = entries.nextElement();
            if (jarEntry.isDirectory() || !(entryName = jarEntry.getName()).endsWith(".class") || !entryName.startsWith(this.sniffPackage) || entryName.indexOf(36) != -1) continue;
            String className = entryName.replace(".class", "").replace('/', '.');
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            this.loadIfInstrumentable(className, new DataInputStream(inputStream));
            inputStream.close();
        }
        jarFile.close();
        return true;
    }

    private boolean seachInstrumentableDirectory(String classRoot, String searchPath) throws IOException, ClassNotFoundException {
        File directory = new File(searchPath);
        if (!directory.isDirectory()) {
            return false;
        }
        for (File fileEntry : directory.listFiles()) {
            if (fileEntry.isDirectory()) {
                this.seachInstrumentableDirectory(classRoot, fileEntry.getPath());
                continue;
            }
            String fileName = fileEntry.getPath();
            String className = fileName.replace(classRoot, "");
            if (!className.endsWith(".class") || !className.startsWith(this.sniffPackage) || className.indexOf(36) != -1) continue;
            className = className.replace(".class", "").replace('/', '.');
            FileInputStream inputStream = new FileInputStream(fileEntry);
            this.loadIfInstrumentable(className, new DataInputStream(inputStream));
            ((InputStream)inputStream).close();
        }
        return true;
    }

    private void loadIfInstrumentable(String className, DataInputStream classInputStream) throws IOException, ClassNotFoundException {
        ClassFile classFile = new ClassFile(classInputStream);
        if (classFile.isAbstract()) {
            return;
        }
        for (String iface : classFile.getInterfaces()) {
            if (!iface.startsWith("java.sql") || !completionMap.containsKey(iface)) continue;
            LOGGER.info("Instrumenting class {}", (Object)className);
            ClassLoaderUtils.loadClass(className);
            completionMap.put(iface, true);
        }
    }

    private String getSearchPath(DataSource dataSource) {
        URL resource = dataSource.getClass().getResource('/' + dataSource.getClass().getName().replace('.', '/') + ".class");
        if (resource == null) {
            return null;
        }
        String path = resource.toString();
        if (path.startsWith("jar:")) {
            path = path.substring(4, path.indexOf(33)).replace(":/", ":///");
        } else if (path.startsWith("file:")) {
            path = path.substring(0, path.lastIndexOf(47)).replace("file:", "");
        } else {
            LOGGER.warn("Could not determine path type of {}", (Object)path);
            return null;
        }
        return path;
    }

    private String getDataSourcePackage(DataSource dataSource) {
        String packageName = dataSource.getClass().getPackage().getName();
        int dots = 0;
        int[] offset = new int[16];
        int ndx = packageName.indexOf(46);
        while (ndx != -1) {
            offset[dots] = ndx;
            ++dots;
            ndx = packageName.indexOf(46, ndx + 1);
        }
        if (dots > 1) {
            packageName = packageName.substring(0, offset[dots - 1]);
        }
        return packageName.replace('.', '/');
    }

    private String getSelfJarPath() {
        URL resource = HikariClassTransformer.class.getResource('/' + HikariClassTransformer.class.getName().replace('.', '/') + ".class");
        if (resource == null) {
            return null;
        }
        String jarPath = resource.toString();
        jarPath = jarPath.replace("file:", "");
        if ((jarPath = jarPath.replace("jar:", "")).indexOf(33) <= 0) {
            return System.getProperty("com.zaxxer.hikari.selfJar");
        }
        jarPath = jarPath.substring(0, jarPath.indexOf(33));
        return jarPath;
    }

    private void registerInstrumentation(String jarPath) throws AttachNotSupportedException, IOException, AgentLoadException, AgentInitializationException {
        VirtualMachine vm = VirtualMachine.attach(this.getPid());
        vm.loadAgent(jarPath, this.sniffPackage);
        vm.detach();
    }

    private void unregisterInstrumenation() {
        HikariClassTransformer.unregisterInstrumenation();
    }

    private String getPid() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        return nameOfRunningVM.substring(0, p);
    }

    static {
        completionMap.put("java.sql.Connection", false);
        completionMap.put("java.sql.ResultSet", false);
    }
}

