/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import java.util.TimerTask;
import org.slf4j.LoggerFactory;

public class LeakTask
extends TimerTask {
    private final long leakTime;
    private StackTraceElement[] stackTrace;

    public LeakTask(StackTraceElement[] stackTrace, long leakDetectionThreshold) {
        this.stackTrace = stackTrace;
        this.leakTime = System.currentTimeMillis() + leakDetectionThreshold;
    }

    public void run() {
        if (System.currentTimeMillis() > this.leakTime) {
            Exception e = new Exception();
            e.setStackTrace(this.stackTrace);
            LoggerFactory.getLogger(LeakTask.class).warn("Connection leak detection triggered, stack trace follows", (Throwable)e);
            this.stackTrace = null;
        }
    }

    public boolean cancel() {
        boolean cancelled = super.cancel();
        if (cancelled) {
            this.stackTrace = null;
        }
        return cancelled;
    }
}

