/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.javassist.HikariInject;
import com.zaxxer.hikari.proxy.ConnectionProxy;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.IHikariResultSetProxy;
import com.zaxxer.hikari.proxy.IHikariStatementProxy;
import com.zaxxer.hikari.proxy.JavassistProxyFactoryFactory;
import com.zaxxer.hikari.proxy.ProxyFactory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PreparedStatementProxy
implements IHikariStatementProxy {
    private static ProxyFactory PROXY_FACTORY;
    @HikariInject
    private IHikariConnectionProxy _connection;
    protected Statement delegate;

    protected PreparedStatementProxy(ConnectionProxy connection, PreparedStatement statement) {
        this._connection = connection;
        this.delegate = statement;
    }

    @HikariInject
    public void setConnectionProxy(IHikariConnectionProxy connection) {
        this._connection = connection;
    }

    @HikariInject
    public SQLException checkException(SQLException e) {
        return this._connection.checkException(e);
    }

    @HikariInject
    public ResultSet executeQuery() throws SQLException {
        try {
            IHikariResultSetProxy resultSet = (IHikariResultSetProxy)((Object)this.__executeQuery());
            if (resultSet == null) {
                return null;
            }
            resultSet.setProxyStatement(this);
            return (ResultSet)((Object)resultSet);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public void close() throws SQLException {
        this._connection.unregisterStatement(this);
        try {
            this.__close();
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            IHikariResultSetProxy resultSet = (IHikariResultSetProxy)((Object)this.__executeQuery(sql));
            if (resultSet == null) {
                return null;
            }
            resultSet.setProxyStatement(this);
            return (ResultSet)((Object)resultSet);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            IHikariResultSetProxy resultSet = (IHikariResultSetProxy)((Object)this.__getGeneratedKeys());
            if (resultSet == null) {
                return null;
            }
            resultSet.setProxyStatement(this);
            return (ResultSet)((Object)resultSet);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    public ResultSet __executeQuery() throws SQLException {
        ResultSet resultSet = ((PreparedStatement)this.delegate).executeQuery();
        return PROXY_FACTORY.getProxyResultSet(this, resultSet);
    }

    private static void __static() {
        if (PROXY_FACTORY == null) {
            PROXY_FACTORY = JavassistProxyFactoryFactory.getProxyFactory();
        }
    }

    public void __close() throws SQLException {
        if (this.delegate.isClosed()) {
            return;
        }
        this.delegate.close();
    }

    public ResultSet __executeQuery(String sql) throws SQLException {
        ResultSet resultSet = this.delegate.executeQuery(sql);
        return PROXY_FACTORY.getProxyResultSet(this, resultSet);
    }

    public ResultSet __getGeneratedKeys() throws SQLException {
        ResultSet generatedKeys = this.delegate.getGeneratedKeys();
        return PROXY_FACTORY.getProxyResultSet(this, generatedKeys);
    }

    static {
        PreparedStatementProxy.__static();
    }
}

