/*
 * Decompiled with CFR 0.152.
 */
package com.zhokhov.graphql.datetime.boot;

import com.zhokhov.graphql.datetime.GraphQLDate;
import com.zhokhov.graphql.datetime.GraphQLDuration;
import com.zhokhov.graphql.datetime.GraphQLLocalDate;
import com.zhokhov.graphql.datetime.GraphQLLocalDateTime;
import com.zhokhov.graphql.datetime.GraphQLLocalTime;
import com.zhokhov.graphql.datetime.GraphQLOffsetDateTime;
import com.zhokhov.graphql.datetime.GraphQLYearMonth;
import com.zhokhov.graphql.datetime.boot.GraphQLDateTimeProperties;
import graphql.kickstart.tools.boot.GraphQLJavaToolsAutoConfiguration;
import java.time.format.DateTimeFormatter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={GraphQLJavaToolsAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQLDateTimeProperties.class})
public class GraphQLDateTimeAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GraphQLDate graphQLDate(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getDate().getScalarName();
        if (name == null) {
            return new GraphQLDate();
        }
        return new GraphQLDate(name);
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLLocalDate graphQLLocalDate(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getLocalDate().getScalarName();
        String format = configurationProperties.getLocalDate().getFormat();
        if (format != null) {
            return new GraphQLLocalDate(name, configurationProperties.isZoneConversionEnabled(), DateTimeFormatter.ofPattern(format));
        }
        return new GraphQLLocalDate(name, configurationProperties.isZoneConversionEnabled());
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLLocalDateTime graphQLLocalDateTime(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getLocalDateTime().getScalarName();
        String format = configurationProperties.getLocalDateTime().getFormat();
        if (format != null) {
            return new GraphQLLocalDateTime(name, configurationProperties.isZoneConversionEnabled(), DateTimeFormatter.ofPattern(format));
        }
        return new GraphQLLocalDateTime(name, configurationProperties.isZoneConversionEnabled());
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLLocalTime graphQLLocalTime(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getLocalTime().getScalarName();
        if (name == null) {
            return new GraphQLLocalTime();
        }
        return new GraphQLLocalTime(name);
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLOffsetDateTime graphQLOffsetDateTime(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getOffsetDateTime().getScalarName();
        if (name == null) {
            return new GraphQLOffsetDateTime();
        }
        return new GraphQLOffsetDateTime(name);
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLYearMonth graphQLYearMonth(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getYearMonth().getScalarName();
        if (name == null) {
            return new GraphQLYearMonth();
        }
        return new GraphQLYearMonth(name);
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLDuration graphQLDuration(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getDuration().getScalarName();
        if (name == null) {
            return new GraphQLDuration();
        }
        return new GraphQLDuration(name);
    }
}

