/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.form;

import de.agilecoders.wicket.core.util.Attributes;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BootstrapCheckbox
extends FormComponentPanel<Boolean> {
    private final WebMarkupContainer wrapper;
    private boolean inline = false;
    private CheckBox checkbox;

    public BootstrapCheckbox(String id) {
        this(id, null);
    }

    public BootstrapCheckbox(String id, IModel<Boolean> model) {
        this(id, model, null);
    }

    public BootstrapCheckbox(String id, IModel<Boolean> model, IModel<?> labelModel) {
        super(id, model);
        this.setType(Boolean.class);
        this.setRenderBodyOnly(true);
        this.wrapper = this.newCheckboxContainer("wrapper");
        this.add(new Component[]{this.wrapper});
        this.wrapper.add(new Component[]{this.newLabel("label", labelModel).add(new Behavior[]{new AttributeModifier("for", (IModel)new Model<String>(){

            public String getObject() {
                return BootstrapCheckbox.this.getCheckbox().getMarkupId(true);
            }
        })})});
        this.checkbox = this.getCheckbox();
        this.wrapper.add(new Component[]{this.checkbox});
    }

    private CheckBox getCheckbox() {
        if (this.checkbox == null) {
            this.checkbox = this.newCheckBox("checkbox", (IModel<Boolean>)this.getModel());
            this.checkbox.setOutputMarkupId(true);
        }
        return this.checkbox;
    }

    protected CheckBox newCheckBox(String id, IModel<Boolean> model) {
        return new CheckBox(id, model);
    }

    protected Component newLabel(String id, IModel<?> labelModel) {
        return new Label(id, labelModel){

            protected void onConfigure() {
                super.onConfigure();
                IModel model = this.getDefaultModel();
                this.setVisible(model != null && model.getObject() != null);
            }
        };
    }

    protected WebMarkupContainer newCheckboxContainer(String id) {
        return new WebMarkupContainer(id){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (BootstrapCheckbox.this.isInline()) {
                    Attributes.addClass(tag, "form-check-inline");
                }
            }
        };
    }

    public boolean isInline() {
        return this.inline;
    }

    public BootstrapCheckbox setInline(boolean inline) {
        this.inline = inline;
        return this;
    }

    public BootstrapCheckbox setLabel(IModel<String> label) {
        this.checkbox.setLabel(label);
        return this;
    }

    public IModel<String> getLabel() {
        return this.checkbox.getLabel();
    }

    public void convertInput() {
        this.setConvertedInput(this.checkbox.getConvertedInput());
    }
}

