/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.navbar;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Activatable;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.Invertible;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.INavbarComponent;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.NavbarText;
import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.BackgroundColorBehavior;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Behaviors;
import de.agilecoders.wicket.core.util.Models;
import de.agilecoders.wicket.jquery.util.Generics2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.basic.EnclosureContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class Navbar
extends Panel
implements Invertible<Navbar> {
    private static final String COMPONENT_ID = "component";
    private static final NavbarComponentToComponentFunction NAVBAR_COMPONENT_TO_COMPONENT_FUNCTION = new NavbarComponentToComponentFunction(Navbar.componentId());
    private static final PositionFilter POSITION_FILTER_LEFT = new PositionFilter(ComponentPosition.LEFT);
    private static final PositionFilter POSITION_FILTER_RIGHT = new PositionFilter(ComponentPosition.RIGHT);
    private final IModel<String> invertModel = Model.of((Serializable)((Object)"navbar-light"));
    private final IModel<BackgroundColorBehavior.Color> backgroundColor = Model.of((Serializable)((Object)BackgroundColorBehavior.Color.Light));
    private CssClassNameAppender activeStateAppender;
    private final IModel<CollapseBreakpoint> collapseBreakpoint = Model.of((Serializable)((Object)CollapseBreakpoint.Large));
    private final IModel<Position> position = Model.of((Serializable)((Object)Position.DEFAULT));
    private final Component brandNameLink;
    private final List<INavbarComponent> components = new ArrayList<INavbarComponent>();
    private final RepeatingView extraItems;

    public static String componentId() {
        return COMPONENT_ID;
    }

    public Navbar(String componentId) {
        this(componentId, (IModel<?>)Model.of());
    }

    public Navbar(String componentId, IModel<?> model) {
        super(componentId, model);
        BootstrapResourcesBehavior.addTo((Component)this);
        TransparentWebMarkupContainer collapse = this.newCollapseContainer("collapse");
        TransparentWebMarkupContainer collapseButton = this.newCollapseButton("collapseButton", "#" + collapse.getMarkupId());
        this.brandNameLink = this.newBrandNameLink("brandName");
        Component leftAlignedComponentListView = this.newNavigation("navLeftList", this.newPositionDependedComponentModel(this.components, POSITION_FILTER_LEFT));
        Component rightAlignedComponentListView = this.newNavigation("navRightList", this.newPositionDependedComponentModel(this.components, POSITION_FILTER_RIGHT));
        this.extraItems = new RepeatingView("extraItems");
        collapse.add(new Component[]{this.extraItems});
        this.activeStateAppender = new CssClassNameAppender("active");
        EnclosureContainer navLeftListEnclosure = new EnclosureContainer("navLeftListEnclosure", leftAlignedComponentListView);
        navLeftListEnclosure.add(new Component[]{leftAlignedComponentListView});
        navLeftListEnclosure.setRenderBodyOnly(false).setOutputMarkupPlaceholderTag(true);
        EnclosureContainer navRightListEnclosure = new EnclosureContainer("navRightListEnclosure", rightAlignedComponentListView);
        navRightListEnclosure.add(new Component[]{rightAlignedComponentListView});
        navRightListEnclosure.setRenderBodyOnly(false).setOutputMarkupPlaceholderTag(true);
        collapse.add(new Component[]{navLeftListEnclosure, navRightListEnclosure});
        this.add(new Component[]{collapse, collapseButton, this.brandNameLink});
        collapseButton.add(new Component[]{this.newToggleNavigationLabel("toggleNavigationLabel")});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Attributes.addClass(tag, "navbar", ((CollapseBreakpoint)((Object)this.collapseBreakpoint.getObject())).cssClassName(), (String)this.invertModel.getObject(), ((Position)this.position.getObject()).cssClassName(), ((BackgroundColorBehavior.Color)((Object)this.backgroundColor.getObject())).cssClassName());
        Attributes.set(tag, "role", "navigation");
    }

    private IModel<List<Component>> newPositionDependedComponentModel(final List<INavbarComponent> components, final PositionFilter withPosition) {
        return new LoadableDetachableModel<List<Component>>(){

            public List<Component> load() {
                return Generics2.transform((List)Generics2.filter((Iterable)components, (Predicate)withPosition), (Function)NAVBAR_COMPONENT_TO_COMPONENT_FUNCTION);
            }
        };
    }

    protected Component newNavigation(String componentId, IModel<List<Component>> listModel) {
        return new ListView<Component>(componentId, listModel){

            protected void populateItem(ListItem<Component> components) {
                Activatable activatable;
                Component component = (Component)components.getModelObject();
                components.add(new Behavior[]{new CssClassNameAppender("nav-item")});
                components.add(new Component[]{component});
                Behaviors.remove(components, (Behavior)Navbar.this.activeStateAppender);
                if (component instanceof Activatable && (activatable = (Activatable)component).isActive(component)) {
                    components.add(new Behavior[]{Navbar.this.activeStateAppender});
                }
                if (component instanceof Invertible) {
                    ((Invertible)component).setInverted(!Models.isNullOrEmpty((IModel<String>)Navbar.this.invertModel));
                }
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(this.getList().size() > 0);
            }
        };
    }

    protected Component newBrandNameLink(String componentId) {
        BookmarkablePageLink<Page> link = new BookmarkablePageLink<Page>(componentId, this.getHomePage()){

            protected void onConfigure() {
                super.onConfigure();
                Component brandLabel = this.get("brandLabel");
                brandLabel.configure();
                if (brandLabel.isVisible()) {
                    this.setVisible(true);
                } else {
                    Component brandImage = this.get("brandImage");
                    brandImage.configure();
                    this.setVisible(brandImage.isVisible());
                }
            }
        };
        link.setOutputMarkupPlaceholderTag(true);
        link.add(new Component[]{this.newBrandLabel("brandLabel")});
        link.add(new Component[]{this.newBrandImage("brandImage")});
        return link;
    }

    protected Label newBrandLabel(String markupId) {
        return new Label(markupId){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(this.getDefaultModel() != null);
            }
        };
    }

    protected Image newBrandImage(String markupId) {
        return new Image(markupId, (IModel)Model.of((Serializable)((Object)""))){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(this.isResourceSet());
            }

            private boolean isResourceSet() {
                return this.getImageResourceReference() != null || this.getImageResource() != null;
            }

            protected boolean getStatelessHint() {
                return this.isResourceSet() ? super.getStatelessHint() : true;
            }
        };
    }

    protected Class<? extends Page> getHomePage() {
        return this.getApplication().getHomePage();
    }

    public Position getPosition() {
        return (Position)this.position.getObject();
    }

    public BackgroundColorBehavior.Color getBackgroundColor() {
        return (BackgroundColorBehavior.Color)((Object)this.backgroundColor.getObject());
    }

    public CollapseBreakpoint getCollapseBreakpoint() {
        return (CollapseBreakpoint)((Object)this.collapseBreakpoint.getObject());
    }

    public final Navbar addComponents(INavbarComponent ... components) {
        return this.addComponents(Generics2.newArrayList((Object[])components));
    }

    public final Navbar addComponents(NavbarText component) {
        this.extraItems.add(new Component[]{component});
        return this;
    }

    public final String newExtraItemId() {
        return this.extraItems.newChildId();
    }

    public final Navbar addComponents(List<INavbarComponent> components) {
        this.components.addAll(components);
        return this;
    }

    protected Label newToggleNavigationLabel(String componentId) {
        return new Label(componentId, (Serializable)((Object)"Toggle Navigation"));
    }

    protected TransparentWebMarkupContainer newCollapseButton(String componentId, String selector) {
        TransparentWebMarkupContainer button = new TransparentWebMarkupContainer(componentId);
        Args.notNull((Object)selector, (String)"selector");
        button.add(new Behavior[]{new AttributeModifier("data-target", (Serializable)((Object)selector))});
        return button;
    }

    protected TransparentWebMarkupContainer newCollapseContainer(String componentId) {
        TransparentWebMarkupContainer collapse = new TransparentWebMarkupContainer(componentId);
        collapse.setOutputMarkupId(true);
        return collapse;
    }

    public Navbar setBrandName(IModel<String> brandName) {
        Component name = this.brandNameLink.get("brandLabel");
        name.setDefaultModel(brandName);
        return this;
    }

    public Navbar setBrandImage(ResourceReference imageResourceReference, IModel<String> imageAltAttrModel) {
        Image brandImage = (Image)this.brandNameLink.get("brandImage");
        brandImage.setImageResourceReference(imageResourceReference);
        if (!Models.isNullOrEmpty(imageAltAttrModel)) {
            brandImage.add(new Behavior[]{new AttributeModifier("alt", imageAltAttrModel)});
        }
        return this;
    }

    @Override
    public Navbar setInverted(boolean invert) {
        this.invertModel.setObject((Object)(invert ? "navbar-dark" : "navbar-light"));
        return this;
    }

    public Navbar setBackgroundColor(BackgroundColorBehavior.Color color) {
        this.backgroundColor.setObject((Object)color);
        return this;
    }

    public Navbar setPosition(Position position) {
        this.position.setObject((Object)position);
        return this;
    }

    public Navbar setCollapseBreakdown(CollapseBreakpoint breakpoint) {
        this.collapseBreakpoint.setObject((Object)breakpoint);
        return this;
    }

    private static final class NavbarComponentToComponentFunction
    implements Function<INavbarComponent, Component>,
    IClusterable {
        private final String markupId;

        private NavbarComponentToComponentFunction(String markupId) {
            Args.isFalse((boolean)Strings.isEmpty((CharSequence)markupId), (String)"markupId", (Object[])new Object[0]);
            this.markupId = markupId;
        }

        @Override
        public Component apply(INavbarComponent navbarComponent) {
            return navbarComponent.create(this.markupId);
        }
    }

    private static final class PositionFilter
    implements Predicate<INavbarComponent>,
    IClusterable {
        private final ComponentPosition position;

        private PositionFilter(ComponentPosition position) {
            Args.notNull((Object)((Object)position), (String)"position");
            this.position = position;
        }

        @Override
        public boolean test(INavbarComponent navbarComponent) {
            return navbarComponent != null && this.position.equals((Object)navbarComponent.getPosition());
        }
    }

    public static enum CollapseBreakpoint {
        Small("sm"),
        Medium("md"),
        Large("lg"),
        ExtraLarge("xl");

        private final String breakpoint;

        private CollapseBreakpoint(String breakpoint) {
            this.breakpoint = breakpoint;
        }

        public String cssClassName() {
            return String.format("navbar-expand-%s", this.breakpoint);
        }
    }

    public static enum ComponentPosition {
        LEFT,
        RIGHT;

    }

    public static enum Position implements ICssClassNameProvider
    {
        TOP("fixed-top"),
        STICKY_TOP("sticky-top"),
        BOTTOM("fixed-bottom"),
        DEFAULT("");

        private final String className;

        private Position(String className) {
            this.className = className;
        }

        @Override
        public String cssClassName() {
            return this.className;
        }
    }
}

