/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.html;

import de.agilecoders.wicket.core.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.util.string.Strings;

public class MobileViewportMetaTag
extends WebComponent {
    private String width;
    private String height;
    private String initialScale;
    private String minimumScale;
    private String maximumScale;
    private boolean userScalable = true;

    public MobileViewportMetaTag(String id) {
        super(id);
    }

    public String getWidth() {
        return this.width;
    }

    public MobileViewportMetaTag setWidth(String width) {
        this.width = width;
        return this;
    }

    public String getHeight() {
        return this.height;
    }

    public MobileViewportMetaTag setHeight(String height) {
        this.height = height;
        return this;
    }

    public String getInitialScale() {
        return this.initialScale;
    }

    public MobileViewportMetaTag setInitialScale(String value) {
        this.initialScale = value;
        return this;
    }

    public String getMinimumScale() {
        return this.minimumScale;
    }

    public MobileViewportMetaTag setMinimumScale(String minimumScale) {
        this.minimumScale = minimumScale;
        return this;
    }

    public String getMaximumScale() {
        return this.maximumScale;
    }

    public MobileViewportMetaTag setMaximumScale(String maximumScale) {
        this.maximumScale = maximumScale;
        return this;
    }

    public boolean isUserScalable() {
        return this.userScalable;
    }

    public MobileViewportMetaTag setUserScalable(boolean userScalable) {
        this.userScalable = userScalable;
        return this;
    }

    protected void onComponentTag(ComponentTag tag) {
        String _maximumScale;
        String _minimumScale;
        String _initialScale;
        String _height;
        super.onComponentTag(tag);
        Components.assertTag((Component)this, tag, "meta");
        tag.put("name", (CharSequence)"viewport");
        StringBuilder content = new StringBuilder();
        String _width = this.getWidth();
        if (!Strings.isEmpty((String)_width)) {
            content.append("width=").append(_width);
        }
        if (!Strings.isEmpty((String)(_height = this.getHeight()))) {
            this.ensureComma(content);
            content.append("height=").append(_height);
        }
        if (!Strings.isEmpty((String)(_initialScale = this.getInitialScale()))) {
            this.ensureComma(content);
            content.append("initial-scale=").append(_initialScale);
        }
        if (!Strings.isEmpty((String)(_minimumScale = this.getMinimumScale()))) {
            this.ensureComma(content);
            content.append("minimum-scale=").append(_minimumScale);
        }
        if (!Strings.isEmpty((String)(_maximumScale = this.getMaximumScale()))) {
            this.ensureComma(content);
            content.append("maximum-scale=").append(_maximumScale);
        }
        if (!this.isUserScalable()) {
            this.ensureComma(content);
            content.append("user-scalable=no");
        }
        tag.put("content", (CharSequence)content);
    }

    private void ensureComma(StringBuilder content) {
        if (content.length() > 0) {
            content.append(',');
        }
    }
}

