/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.settings;

import de.agilecoders.wicket.core.markup.html.references.BootstrapJavaScriptReference;
import de.agilecoders.wicket.core.markup.html.references.ModernizrJavaScriptReference;
import de.agilecoders.wicket.core.markup.html.references.PopperJavaScriptReference;
import de.agilecoders.wicket.core.markup.html.themes.bootstrap.BootstrapCssReference;
import de.agilecoders.wicket.core.markup.html.themes.bootstrap.BootstrapCssRtlReference;
import de.agilecoders.wicket.core.settings.ActiveThemeProvider;
import de.agilecoders.wicket.core.settings.DefaultThemeProvider;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.NoopThemeProvider;
import de.agilecoders.wicket.core.settings.SessionThemeProvider;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.UrlResourceReference;

public class BootstrapSettings
implements IBootstrapSettings {
    private ResourceReference bootstrapJavaScriptReference = null;
    private ResourceReference modernizrJavaScriptReference = null;
    private ResourceReference bootstrapCssReference = null;
    private ResourceReference bootstrapCssRtlReference = null;
    private ResourceReference popperJavaScriptReference = null;
    private ThemeProvider themeProvider;
    private ActiveThemeProvider activeThemeProvider = new SessionThemeProvider();
    private String resourceFilterName = "";
    private boolean updateSecurityManager = true;
    private boolean autoAppendResources = true;
    private boolean useCdnResources = false;
    private boolean deferJavascript = false;
    private String version = "5.3.3";
    private String modernizrVersion = "2.8.3";
    private String popperVersion = "2.11.8";

    public BootstrapSettings() {
        this.themeProvider = new NoopThemeProvider();
    }

    @Override
    public IBootstrapSettings setVersion(String version) {
        this.version = version;
        return this;
    }

    @Override
    public IBootstrapSettings setModernizrVersion(String version) {
        this.modernizrVersion = version;
        return this;
    }

    @Override
    public IBootstrapSettings setPopperJsVersion(String version) {
        this.popperVersion = version;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean deferJavascript() {
        return this.deferJavascript;
    }

    @Override
    public String getModernizrVersion() {
        return this.modernizrVersion;
    }

    @Override
    public String getPopperJsVersion() {
        return this.popperVersion;
    }

    @Override
    public boolean autoAppendResources() {
        return this.autoAppendResources;
    }

    @Override
    public ResourceReference getCssResourceReference() {
        ResourceReference ref;
        boolean isRtl;
        boolean bl = isRtl = WebSession.exists() && WebSession.get().isRtlLocale();
        if (this.useCdnResources()) {
            String cdnUrl = String.format(isRtl ? "//stackpath.bootstrapcdn.com/bootstrap/%s/css/bootstrap.rtl.min.css" : "//stackpath.bootstrapcdn.com/bootstrap/%s/css/bootstrap.min.css", this.getVersion());
            ref = new UrlResourceReference(Url.parse((CharSequence)cdnUrl));
        } else {
            ResourceReference resourceReference = ref = isRtl ? this.bootstrapCssRtlReference : this.bootstrapCssReference;
        }
        if (ref == null) {
            ref = isRtl ? Holder.bootstrapCssRtlReference : Holder.bootstrapCssReference;
        }
        return ref;
    }

    @Override
    public ResourceReference getJsResourceReference() {
        ResourceReference jsReference;
        if (this.useCdnResources()) {
            String cdnUrl = String.format("//stackpath.bootstrapcdn.com/bootstrap/%s/js/bootstrap.bundle.min.js", this.getVersion());
            jsReference = new UrlResourceReference(Url.parse((CharSequence)cdnUrl));
        } else {
            jsReference = this.bootstrapJavaScriptReference;
        }
        return jsReference != null ? jsReference : Holder.bootstrapJavaScriptReference;
    }

    @Override
    public ResourceReference getModernizrResourceReference() {
        ResourceReference jsReference;
        if (this.useCdnResources()) {
            String cdnUrl = String.format("//cdnjs.cloudflare.com/ajax/libs/modernizr/%s/modernizr.min.js", this.getModernizrVersion());
            jsReference = new UrlResourceReference(Url.parse((CharSequence)cdnUrl));
        } else {
            jsReference = this.modernizrJavaScriptReference;
        }
        return jsReference != null ? jsReference : Holder.modernizrJavaScriptReference;
    }

    @Override
    public ResourceReference getPopperJsResourceReference() {
        ResourceReference jsReference;
        if (this.useCdnResources()) {
            String cdnUrl = String.format("//unpkg.com/popper.js@%s/dist/umd/popper.min.js", this.getPopperJsVersion());
            jsReference = new UrlResourceReference(Url.parse((CharSequence)cdnUrl));
        } else {
            jsReference = this.popperJavaScriptReference;
        }
        return jsReference != null ? jsReference : Holder.popperJavaScriptReference;
    }

    @Override
    public String getJsResourceFilterName() {
        return this.resourceFilterName;
    }

    @Override
    public IBootstrapSettings setAutoAppendResources(boolean value) {
        this.autoAppendResources = value;
        return this;
    }

    @Override
    public ActiveThemeProvider getActiveThemeProvider() {
        return this.activeThemeProvider;
    }

    @Override
    public ThemeProvider getThemeProvider() {
        ThemeProvider provider = this.themeProvider;
        return provider != null ? provider : (this.themeProvider = new DefaultThemeProvider());
    }

    @Override
    public boolean updateSecurityManager() {
        return this.updateSecurityManager;
    }

    @Override
    public IBootstrapSettings setCssResourceReference(ResourceReference reference) {
        this.bootstrapCssReference = reference;
        return this;
    }

    @Override
    public IBootstrapSettings setCssRtlResourceReference(ResourceReference reference) {
        this.bootstrapCssRtlReference = reference;
        return this;
    }

    @Override
    public BootstrapSettings setJsResourceReference(ResourceReference bootstrapJavaScriptReference) {
        this.bootstrapJavaScriptReference = bootstrapJavaScriptReference;
        return this;
    }

    @Override
    public IBootstrapSettings setJsResourceFilterName(String name) {
        this.resourceFilterName = name;
        return this;
    }

    @Override
    public BootstrapSettings setModernizrResourceReference(ResourceReference modernizrJavaScriptReference) {
        this.modernizrJavaScriptReference = modernizrJavaScriptReference;
        return this;
    }

    @Override
    public IBootstrapSettings setPopperJsResourceReference(ResourceReference popperJsResourceReference) {
        this.popperJavaScriptReference = popperJsResourceReference;
        return this;
    }

    @Override
    public IBootstrapSettings setUpdateSecurityManager(boolean activate) {
        this.updateSecurityManager = activate;
        return this;
    }

    @Override
    public IBootstrapSettings setDeferJavascript(boolean defer) {
        this.deferJavascript = defer;
        return this;
    }

    @Override
    public BootstrapSettings setActiveThemeProvider(ActiveThemeProvider activeThemeProvider) {
        this.activeThemeProvider = activeThemeProvider;
        return this;
    }

    @Override
    public BootstrapSettings setThemeProvider(ThemeProvider themeProvider) {
        this.themeProvider = themeProvider;
        return this;
    }

    @Override
    public boolean useCdnResources() {
        return this.useCdnResources;
    }

    @Override
    public final boolean useWebjars() {
        return !this.useCdnResources() && (this.bootstrapCssReference == null || this.bootstrapJavaScriptReference == null || this.modernizrJavaScriptReference == null);
    }

    @Override
    public IBootstrapSettings useCdnResources(boolean useCdnResources) {
        this.useCdnResources = useCdnResources;
        return this;
    }

    private static final class Holder {
        private static ResourceReference bootstrapJavaScriptReference = BootstrapJavaScriptReference.instance();
        private static ResourceReference modernizrJavaScriptReference = ModernizrJavaScriptReference.instance();
        private static ResourceReference bootstrapCssReference = BootstrapCssReference.instance();
        private static ResourceReference bootstrapCssRtlReference = BootstrapCssRtlReference.instance();
        private static ResourceReference popperJavaScriptReference = PopperJavaScriptReference.instance();

        private Holder() {
        }
    }
}

