/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.clockpicker;

import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.Key;

public class ClockPickerConfig
extends AbstractConfig {
    private static final IKey<String> DoneText = new Key("donetext");
    private static final IKey<Boolean> AutoClose = new Key("autoclose");
    private static final IKey<String> Placement = new Key("placement");
    private static final IKey<String> Align = new Key("align");

    public ClockPickerConfig() {
        this.put(DoneText, "Ok");
        this.put(AutoClose, false);
        this.put(Placement, Direction.bottom.value());
        this.put(Align, Direction.top.value());
    }

    public ClockPickerConfig withDoneText(String doneText) {
        this.put(DoneText, doneText);
        return this;
    }

    public ClockPickerConfig withAutoClose(Boolean autoClose) {
        this.put(AutoClose, autoClose);
        return this;
    }

    public ClockPickerConfig withPlacement(Direction direction) {
        this.put(Placement, direction.value());
        return this;
    }

    public ClockPickerConfig withAlign(Direction direction) {
        this.put(Align, direction.value());
        return this;
    }

    public static enum Direction {
        top,
        bottom,
        right,
        left;


        public String value() {
            return this.name();
        }
    }
}

