/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerConfig;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;

public class DatetimePicker
extends DateTextField {
    private static final long serialVersionUID = 1L;
    private DatetimePickerConfig config;

    public DatetimePicker(String id, String datePattern) {
        this(id, null, datePattern);
    }

    public DatetimePicker(String id, IModel<Date> model, String datePattern) {
        super(id, model, datePattern);
        this.config = new DatetimePickerConfig().withFormat(datePattern);
    }

    public DatetimePicker(String id, DatetimePickerConfig config) {
        this(id, null, config.getFormat());
        this.config = config;
    }

    public DatetimePicker(String id, IModel<Date> model, DatetimePickerConfig config) {
        this(id, model, config.getFormat());
        this.config = config;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        String scriptTemplate = "$('#%1$s').on('change.datetimepicker', function(){ $('#%1$s').trigger('change'); })";
        CharSequence markupId = Strings2.getMarkupId((Component)this);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format(scriptTemplate, markupId)));
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{new DatetimePickerBehavior(this.config)});
        if (this.config.getMaskInput().booleanValue()) {
            this.add(new Behavior[]{this.config.newMaskBehavior()});
        }
    }
}

