/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesomeIconType;
import java.io.Serializable;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class DatetimePickerWithIcon
extends Panel {
    private static final long serialVersionUID = 1L;
    private DatetimePickerConfig config;

    public DatetimePickerWithIcon(String markupId, DatetimePickerConfig config) {
        this(markupId, null, config);
    }

    public DatetimePickerWithIcon(String markupId, IModel<Date> model, DatetimePickerConfig config) {
        super(markupId, model);
        this.setDefaultModel(model);
        this.setRenderBodyOnly(true);
        this.config = config;
    }

    protected void onInitialize() {
        super.onInitialize();
        Component input = this.newInput("date", this.config.getFormat()).add(new Behavior[]{new DatetimePickerBehavior(this.config)});
        Component iconContainer = this.newIconContainer("iconContainer").add(new Component[]{this.newIcon("icon")}).add(new Behavior[]{new AttributeAppender("data-target", (Serializable)((Object)("#" + input.getMarkupId())))});
        this.add(new Component[]{new WebMarkupContainer("dateWrapper").add(new Component[]{input, iconContainer})});
    }

    public DatetimePickerWithIcon with(DatetimePickerConfig config) {
        this.config = config;
        return this;
    }

    protected DateTextField newInput(String wicketId, String dateFormat) {
        DateTextField field = new DateTextField(wicketId, this.getDefaultModel(), dateFormat);
        if (this.config.getMaskInput().booleanValue()) {
            field.add(new Behavior[]{this.config.newMaskBehavior()});
        }
        return field;
    }

    protected MarkupContainer newIconContainer(String wicketId) {
        return new WebMarkupContainer(wicketId);
    }

    protected Component newIcon(String wicketId) {
        return new Icon(wicketId, this.newIconType());
    }

    protected IconType newIconType() {
        return FontAwesomeIconType.calendar;
    }
}

