/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.password.strength;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.password.strength.PasswordStrengthActivated;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.password.strength.PasswordStrengthErrorMessages;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.password.strength.PasswordStrengthScores;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.Key;
import org.apache.wicket.Component;
import org.apache.wicket.util.lang.Args;

public class PasswordStrengthConfig
extends AbstractConfig {
    private static final IKey<CommonConfig> COMMON_CONFIG = new Key("common", (Object)new CommonConfig());
    private static final IKey<UiConfig> UI_CONFIG = new Key("ui", (Object)new UiConfig());
    private static final IKey<RulesConfig> RULES_CONFIG = new Key("rules", (Object)new RulesConfig());
    private final CommonConfig commonConfig = new CommonConfig();
    private final RulesConfig rulesConfig;
    private final UiConfig uiConfig;

    public PasswordStrengthConfig() {
        this.put(COMMON_CONFIG, (Object)this.commonConfig);
        this.rulesConfig = new RulesConfig();
        this.put(RULES_CONFIG, (Object)this.rulesConfig);
        this.uiConfig = new UiConfig();
        this.put(UI_CONFIG, (Object)this.uiConfig);
        this.uiConfig.put(UiConfig.UseBootstrap4, true);
    }

    public PasswordStrengthConfig withMinChar(int minChar) {
        this.commonConfig.put(CommonConfig.MinChar, minChar);
        return this;
    }

    public PasswordStrengthConfig withUsernameField(Component usernameField) {
        this.commonConfig.put(CommonConfig.UsernameField, "#" + usernameField.getMarkupId());
        return this;
    }

    public PasswordStrengthConfig withZxcvbn(boolean zxcvbn) {
        this.commonConfig.put(CommonConfig.Zxcvbn, zxcvbn);
        return this;
    }

    public PasswordStrengthConfig withDebug(boolean debug) {
        this.commonConfig.put(CommonConfig.Debug, debug);
        return this;
    }

    public PasswordStrengthConfig withScores(PasswordStrengthScores scores) {
        this.rulesConfig.put(RulesConfig.Scores, (Object)scores);
        return this;
    }

    public PasswordStrengthConfig withActivated(PasswordStrengthActivated activated) {
        this.rulesConfig.put(RulesConfig.Activated, (Object)activated);
        return this;
    }

    public PasswordStrengthConfig withRaisePower(double raisePower) {
        this.rulesConfig.put(RulesConfig.RaisePower, raisePower);
        return this;
    }

    public PasswordStrengthConfig withShowProgressBar(boolean showProgressBar) {
        this.uiConfig.put(UiConfig.ShowProgressBar, showProgressBar);
        return this;
    }

    public PasswordStrengthConfig withShowPopover(boolean showPopover) {
        this.uiConfig.put(UiConfig.ShowPopover, showPopover);
        return this;
    }

    public PasswordStrengthConfig withShowStatus(boolean showStatus) {
        this.uiConfig.put(UiConfig.ShowStatus, showStatus);
        return this;
    }

    public PasswordStrengthConfig withErrorMessages(PasswordStrengthErrorMessages errorMessages) {
        this.uiConfig.put(UiConfig.ErrorMessages, (Object)errorMessages);
        return this;
    }

    public PasswordStrengthConfig withVerdicts(String[] verdicts) {
        Args.notNull((Object)verdicts, (String)"verdicts");
        Args.isTrue((verdicts.length == 5 ? 1 : 0) != 0, (String)"The 'verdicts' must be exactly five!", (Object[])new Object[0]);
        this.uiConfig.put(UiConfig.Verdicts, verdicts);
        return this;
    }

    public PasswordStrengthConfig withShowVerdicts(boolean showVerdicts) {
        this.uiConfig.put(UiConfig.ShowVerdicts, showVerdicts);
        return this;
    }

    public PasswordStrengthConfig withShowVerdictsInsideProgressBar(boolean showVerdictsInsideProgressBar) {
        this.uiConfig.put(UiConfig.ShowVerdictsInsideProgressBar, showVerdictsInsideProgressBar);
        return this;
    }

    public PasswordStrengthConfig withUseVerdictCssClass(boolean useVerdictCssClass) {
        this.uiConfig.put(UiConfig.UseVerdictCssClass, useVerdictCssClass);
        return this;
    }

    public PasswordStrengthConfig withShowErrors(boolean showErrors) {
        this.uiConfig.put(UiConfig.ShowErrors, showErrors);
        return this;
    }

    public PasswordStrengthConfig withScores(int[] scores) {
        Args.notNull((Object)scores, (String)"scores");
        Args.isTrue((scores.length == 4 ? 1 : 0) != 0, (String)"The 'scores' must be exactly four!", (Object[])new Object[0]);
        this.uiConfig.put(UiConfig.Scores, scores);
        return this;
    }

    private static class RulesConfig
    extends AbstractConfig {
        private static final IKey<PasswordStrengthScores> Scores = new Key("scores", (Object)new PasswordStrengthScores());
        private static final IKey<PasswordStrengthActivated> Activated = new Key("activated", (Object)new PasswordStrengthActivated());
        private static final IKey<Double> RaisePower = new Key("raisePower", (Object)1.4);

        private RulesConfig() {
        }
    }

    private static class UiConfig
    extends AbstractConfig {
        private static final IKey<Boolean> ShowProgressBar = new Key("showProgressBar", (Object)true);
        private static final IKey<Boolean> ShowPopover = new Key("showPopover", (Object)false);
        private static final IKey<Boolean> ShowStatus = new Key("showStatus", (Object)false);
        private static final IKey<Boolean> UseVerdictCssClass = new Key("useVerdictCssClass", (Object)false);
        private static final IKey<Boolean> ShowVerdicts = new Key("showVerdicts", (Object)true);
        private static final IKey<Boolean> ShowErrors = new Key("showErrors", (Object)false);
        private static final IKey<Boolean> ShowVerdictsInsideProgressBar = new Key("showVerdictsInsideProgressBar", (Object)false);
        private static final IKey<String[]> Verdicts = new Key("verdicts", (Object)new String[]{"Weak", "Normal", "Medium", "Strong", "Very Strong"});
        private static final IKey<int[]> Scores = new Key("scores", (Object)new int[]{17, 26, 40, 50});
        private static final IKey<PasswordStrengthErrorMessages> ErrorMessages = new Key("errorMessages", (Object)new PasswordStrengthErrorMessages());
        private static final IKey<Boolean> UseBootstrap4 = new Key("bootstrap4", (Object)false);

        private UiConfig() {
        }
    }

    private static class CommonConfig
    extends AbstractConfig {
        private static final IKey<Integer> MinChar = new Key("minChar", (Object)6);
        private static final IKey<String> UsernameField = new Key("usernameField", (Object)"#username");
        private static final IKey<Boolean> Zxcvbn = new Key("zxcvbn", (Object)false);
        private static final IKey<Boolean> Debug = new Key("debug", (Object)false);

        private CommonConfig() {
        }
    }
}

