/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.web.client;

import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.web.client.HttpHeadersProvider;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ApplicationOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationOperations.class);
    private static final Class<Map<String, Serializable>> RESPONSE_TYPE_MAP = Map.class;
    private final RestTemplate restTemplate;
    private final HttpHeadersProvider httpHeadersProvider;

    public ApplicationOperations(RestTemplate restTemplate, HttpHeadersProvider httpHeadersProvider) {
        this.restTemplate = restTemplate;
        this.httpHeadersProvider = httpHeadersProvider;
    }

    public ResponseEntity<Map<String, Serializable>> getInfo(Application application) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)application.getManagementUrl()).pathSegment(new String[]{"info"}).build().toUri();
        return this.doGet(application, uri, RESPONSE_TYPE_MAP);
    }

    public ResponseEntity<Map<String, Serializable>> getHealth(Application application) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)application.getHealthUrl()).build().toUri();
        return this.doGet(application, uri, RESPONSE_TYPE_MAP);
    }

    protected <T> ResponseEntity<T> doGet(Application application, URI uri, Class<T> responseType) {
        LOGGER.debug("Fetching '{}' for {}", (Object)uri, (Object)application);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.putAll((Map)this.httpHeadersProvider.getHeaders(application));
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), responseType);
        LOGGER.debug("'{}' responded with {}", (Object)uri, (Object)response);
        return response;
    }
}

