/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CompositeNotifier
implements Notifier {
    private static final Logger log = LoggerFactory.getLogger(CompositeNotifier.class);
    private final Iterable<Notifier> delegates;

    public CompositeNotifier(Iterable<Notifier> delegates) {
        Assert.notNull(delegates, (String)"'delegates' must not be null!");
        this.delegates = delegates;
    }

    @Override
    public Mono<Void> notify(InstanceEvent event) {
        return Flux.fromIterable(this.delegates).flatMap(d -> d.notify(event).onErrorResume(error -> {
            log.warn("Unexpected exception while triggering notifications. Notification might not be sent.", error);
            return Mono.empty();
        })).then();
    }
}

