/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.functions;

import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import java.util.function.IntFunction;
import org.threeten.extra.chrono.JulianChronology;

public class CalculateJulianEasterSunday
implements IntFunction<LocalDate> {
    @Override
    public LocalDate apply(int year) {
        int a = year % 4;
        int b = year % 7;
        int c = year % 19;
        int d = (19 * c + 15) % 30;
        int e = (2 * a + 4 * b - d + 34) % 7;
        int x = d + e + 114;
        int month = x / 31;
        int day = x % 31 + 1;
        return LocalDate.from((TemporalAccessor)JulianChronology.INSTANCE.date(year, month == 3 ? 3 : 4, day));
    }
}

