/*
 * Decompiled with CFR 0.152.
 */
package de.fumix.holidays.config;

import de.fumix.holidays.Holidays;
import de.fumix.holidays.config.Holiday;
import de.fumix.holidays.config.Region;
import de.fumix.holidays.config.properties.HolidayProperties;
import de.fumix.holidays.config.properties.PropertiesLoader;
import de.fumix.holidays.config.properties.RegionProperties;
import de.fumix.holidays.impl.HolidaysImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger LOG = LoggerFactory.getLogger(Config.class);
    static final String HOLIDAY_PROPERTIES = "/de/fumix/holidays/holiday.properties";
    static final String REGION_DE_PROPERTIES = "/de/fumix/holidays/region_DE.properties";
    static final String REGION_AT_PROPERTIES = "/de/fumix/holidays/region_AT.properties";
    final LinkedHashMap<String, Holiday> holidays = new LinkedHashMap();
    final LinkedHashMap<String, Region> regions = new LinkedHashMap();

    public Optional<Region> regionOf(String abbrev) {
        return Optional.ofNullable(this.regions.get(abbrev));
    }

    public Optional<Holiday> holidayOf(String abbrev) {
        return Optional.ofNullable(this.holidays.get(abbrev));
    }

    public static ResourceBundle getHolidaysBundle(Locale locale) {
        return ResourceBundle.getBundle("de.fumix.holidays.messages");
    }

    public static Config fromResources() {
        String logPrefix = "[fromResources()]";
        Config config = new Config();
        LOG.debug("{} Loading holidays from resource file {}", (Object)"[fromResources()]", (Object)HOLIDAY_PROPERTIES);
        LinkedHashMap<String, String> holidayProperties = new LinkedHashMap<String, String>();
        PropertiesLoader.load(HOLIDAY_PROPERTIES, holidayProperties::put);
        HolidayProperties.from(holidayProperties, xva$0 -> config.addHoliday((Holiday)xva$0));
        LinkedHashMap<String, String> regionProperties = new LinkedHashMap<String, String>();
        PropertiesLoader.load(REGION_DE_PROPERTIES, regionProperties::put);
        PropertiesLoader.load(REGION_AT_PROPERTIES, regionProperties::put);
        RegionProperties.from(regionProperties, config.holidays, config::addRegion);
        return config;
    }

    public Config addRegion(Region region) {
        this.regions.put(region.getRegionId(), region);
        return this;
    }

    public Config addHoliday(Holiday ... holidays) {
        Arrays.stream(holidays).forEach(holiday -> this.holidays.put(holiday.getHolidayId(), (Holiday)holiday));
        return this;
    }

    public List<Region> getRegions() {
        return new ArrayList<Region>(this.regions.values());
    }

    public Holidays forRegion(Region region) {
        return new HolidaysImpl(region);
    }
}

