/*
 * Decompiled with CFR 0.152.
 */
package de.fumix.holidays.config.properties;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesLoader.class);

    public static void load(String propsPath, BiConsumer<String, String> propConsumer) {
        String logPrefix = "[load()]";
        URL resource = PropertiesLoader.class.getResource(propsPath);
        LOG.debug("{} Loading property resources '{}'", (Object)"[load()]", (Object)resource);
        try (InputStream inputStream = resource.openStream();){
            if (inputStream == null) {
                throw new IllegalArgumentException("Property file not found on classpath: '" + propsPath + "'");
            }
            PropertiesLoader.load(inputStream, propConsumer);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Resource file not found: '" + propsPath + "'", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading resource file: '" + propsPath + "'", e);
        }
    }

    public static void load(InputStream inStream, final BiConsumer<String, String> propConsumer) throws IOException {
        Properties properties = new Properties(){

            @Override
            public Object put(Object key, Object value) {
                propConsumer.accept((String)key, (String)value);
                return null;
            }
        };
        properties.load(inStream);
    }
}

