/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.streaming;

import de.huxhorn.sulky.codec.Encoder;
import de.huxhorn.sulky.codec.streaming.StreamingEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncoderBridge<E>
implements Encoder<E> {
    private final Logger logger = LoggerFactory.getLogger(EncoderBridge.class);
    private StreamingEncoder<E> wrapped;

    public EncoderBridge(StreamingEncoder<E> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public byte[] encode(E object) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.wrapped.encode(object, bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while encoding {}!", object, (Object)e);
            }
            return null;
        }
    }
}

