/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;

public final class IOUtilities {
    private IOUtilities() {
    }

    public static void interruptIfNecessary(Throwable t) {
        if (t == null) {
            return;
        }
        Throwable current = t;
        do {
            if (!(current instanceof InterruptedIOException) && !(current instanceof InterruptedException)) continue;
            Thread.currentThread().interrupt();
            break;
        } while ((current = current.getCause()) != null);
    }

    public static void closeQuietly(InputStream x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (IOException e) {
            IOUtilities.interruptIfNecessary(e);
        }
    }

    public static void closeQuietly(Reader x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (IOException e) {
            IOUtilities.interruptIfNecessary(e);
        }
    }

    public static void closeQuietly(OutputStream x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (IOException e) {
            IOUtilities.interruptIfNecessary(e);
        }
    }

    public static void closeQuietly(Writer x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (IOException e) {
            IOUtilities.interruptIfNecessary(e);
        }
    }

    public static void closeQuietly(RandomAccessFile x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (IOException e) {
            IOUtilities.interruptIfNecessary(e);
        }
    }
}

