/*
 * Decompiled with CFR 0.152.
 */
package de.ingogriebsch.maven.sync.packagejson.version.plugin;

import de.ingogriebsch.maven.sync.packagejson.version.plugin.Logger;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.PackageJson;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.PackageJsonCollector;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.PomVersionEvaluatorFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractMojo
extends org.apache.maven.plugin.AbstractMojo {
    private final PomVersionEvaluatorFactory pomVersionEvaluationFactory;
    private final PackageJsonCollector packageJsonCollector;
    protected final Logger logger = Logger.logger(() -> ((AbstractMojo)this).getLog());
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    protected AbstractMojo() {
        this.pomVersionEvaluationFactory = new PomVersionEvaluatorFactory(this.logger);
        this.packageJsonCollector = new PackageJsonCollector(this.logger);
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipped()) {
            this.logger.info("Execution is skipped on purpose!", new Object[0]);
            return;
        }
        String packaging = this.project.getPackaging();
        if (!this.supportsPackaging(packaging)) {
            this.logger.info("Execution is skipped because the packaing of this project [%s] is not supported!", packaging);
            return;
        }
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Caught exception while validating this mojo!", e);
        }
        try {
            this.doExecute();
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Caught exception while execute this mojo!", e);
        }
    }

    protected abstract boolean isSkipped();

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected abstract String getPomVersionEvaluation();

    protected void validate() throws Exception {
        String pomVersionEvaluation = this.getPomVersionEvaluation();
        Set<String> pomVersionEvaluations = this.pomVersionEvaluationFactory.getIds();
        if (!pomVersionEvaluations.contains(pomVersionEvaluation)) {
            throw new IllegalArgumentException(String.format("Property 'pomVersionEvaluation' must contain one of the following values '%s' but contains value '%s'!", Arrays.toString(pomVersionEvaluations.toArray()), pomVersionEvaluation));
        }
    }

    protected boolean supportsPackaging(String packaging) {
        return true;
    }

    protected String evaluatePomVersion(MavenProject mavenProject) {
        return this.pomVersionEvaluationFactory.create(this.getPomVersionEvaluation()).map(p -> p.get(this.project)).orElseThrow();
    }

    protected List<PackageJson> collectPackageJsons(String[] includes, String[] excludes) {
        return this.packageJsonCollector.collect(PackageJsonCollector.Params.of(this.project.getBasedir(), includes, excludes));
    }
}

