/*
 * Decompiled with CFR 0.152.
 */
package de.ingogriebsch.maven.sync.packagejson.version.plugin;

import java.util.function.Supplier;
import org.apache.maven.plugin.logging.Log;

public class Logger {
    private final Supplier<Log> source;

    private Logger(Supplier<Log> source) {
        this.source = source;
    }

    public static Logger logger(Supplier<Log> source) {
        return new Logger(source);
    }

    public static Logger noOpLogger() {
        return Logger.logger(() -> new NoOpLog());
    }

    public void debug(String message, Object ... args) {
        Log log = this.source.get();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)String.format(message, args));
        }
    }

    public void info(String message, Object ... args) {
        Log log = this.source.get();
        if (log.isInfoEnabled()) {
            log.info((CharSequence)String.format(message, args));
        }
    }

    public void warn(String message, Object ... args) {
        Log log = this.source.get();
        if (log.isWarnEnabled()) {
            log.warn((CharSequence)String.format(message, args));
        }
    }

    public void error(String message, Object ... args) {
        Log log = this.source.get();
        if (log.isErrorEnabled()) {
            log.error((CharSequence)String.format(message, args));
        }
    }

    private static class NoOpLog
    implements Log {
        private NoOpLog() {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public void debug(CharSequence content) {
        }

        public void debug(CharSequence content, Throwable error) {
        }

        public void debug(Throwable error) {
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public void info(CharSequence content) {
        }

        public void info(CharSequence content, Throwable error) {
        }

        public void info(Throwable error) {
        }

        public boolean isWarnEnabled() {
            return false;
        }

        public void warn(CharSequence content) {
        }

        public void warn(CharSequence content, Throwable error) {
        }

        public void warn(Throwable error) {
        }

        public boolean isErrorEnabled() {
            return false;
        }

        public void error(CharSequence content) {
        }

        public void error(CharSequence content, Throwable error) {
        }

        public void error(Throwable error) {
        }
    }
}

